/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.common.exception.ShopsException;
import com.bxm.shop.common.utils.CalculateUtils;
import com.bxm.shop.facade.model.GoodDetailVo;
import com.bxm.shop.facade.model.GoodVo;
import com.bxm.shop.facade.model.GoodsQueryRo;
import com.bxm.shop.integration.pdd.PddGoodsIntegration;
import com.bxm.shop.model.Good;
import com.bxm.shop.model.GoodDetail;
import com.bxm.shop.model.Reappearance;
import com.bxm.shop.service.GoodsService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class GoodsServiceImpl
implements GoodsService {
    private static final Logger log = LoggerFactory.getLogger(GoodsServiceImpl.class);
    @Resource
    private PddGoodsIntegration pddGoodsIntegration;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private Mapper mapper;

    @Override
    public List<GoodVo> getList(GoodsQueryRo goodsQueryRo) {
        List goods;
        long startIndex;
        List cacheGoods = new ArrayList();
        List goodsIdList = new ArrayList();
        long size = this.stringRedisTemplate.opsForList().size((Object)"MINIPROGRAM:GOODSPOOL:LIST:2");
        if (size - ((startIndex = (long)((goodsQueryRo.getPageNum() - 1) * goodsQueryRo.getPageSize())) + 1L) > 0L) {
            long exceptEndIndex = startIndex + (long)goodsQueryRo.getPageSize().intValue();
            boolean enough = exceptEndIndex <= size - 1L;
            goodsIdList = this.stringRedisTemplate.opsForList().range((Object)"MINIPROGRAM:GOODSPOOL:LIST:2", 0L, size);
            cacheGoods = this.pddGoodsIntegration.queryGoodsList(goodsIdList.subList((int)startIndex, enough ? (int)exceptEndIndex : (int)size));
            if (enough) {
                return cacheGoods.stream().map(this::trans2Vo).collect(Collectors.toList());
            }
        }
        int remain = (int)(size % (long)goodsQueryRo.getPageSize().intValue());
        long offsetPage = size / (long)goodsQueryRo.getPageSize().intValue();
        long pageNum = goodsQueryRo.getPageNum().intValue();
        goodsQueryRo.setPageNum(Integer.valueOf((int)(pageNum - offsetPage)));
        ArrayList result = new ArrayList(goodsQueryRo.getPageSize());
        if (cacheGoods.isEmpty()) {
            goodsQueryRo.setPageNum(goodsQueryRo.getPageNum());
            goods = this.pddGoodsIntegration.queryGoodsList(goodsQueryRo);
            if (goods != null) {
                result.addAll(goods.subList(remain, goods.size()));
            }
            goodsQueryRo.setPageNum(Integer.valueOf(goodsQueryRo.getPageNum() + 1));
        } else {
            result.addAll(cacheGoods);
        }
        goods = this.pddGoodsIntegration.queryGoodsList(goodsQueryRo);
        if (goods != null) {
            result.addAll(goods.subList(0, remain));
        }
        ArrayList<GoodVo> vos = new ArrayList<GoodVo>(result.size());
        for (Good good : result) {
            if (goodsIdList.contains(good.getGoodsId().toString())) continue;
            vos.add(this.trans2Vo(good));
        }
        return vos;
    }

    @Override
    public GoodDetailVo getDetail(String goodId) {
        if (goodId == null) {
            throw new ShopsException(ResponseCodeType.PARAM_ILLEGAL, new String[0]);
        }
        GoodDetail goodDetail = this.pddGoodsIntegration.queryGoodDetail(goodId);
        GoodDetailVo goodDetailVo = (GoodDetailVo)this.mapper.map((Object)this.trans2Vo(goodDetail), GoodDetailVo.class);
        goodDetailVo.setGoodsGalleryUrls(goodDetail.getGoodsGalleryUrls());
        Long size = this.stringRedisTemplate.opsForList().size((Object)"MINIPROGRAM:POP:LIST");
        long POP_SIZE = 15L;
        long startIndex = (long)(Math.random() * (double)size.longValue());
        startIndex = size - 15L < startIndex ? size - 15L : startIndex;
        List popStrings = this.stringRedisTemplate.opsForList().range((Object)"MINIPROGRAM:POP:LIST", startIndex, startIndex + 15L);
        goodDetailVo.setPops(popStrings.stream().map(popString -> (GoodDetailVo.Pop)JSONObject.parseObject((String)popString, GoodDetailVo.Pop.class)).collect(Collectors.toList()));
        return goodDetailVo;
    }

    @Override
    public List<GoodVo> search(GoodsQueryRo goodsQueryRo) {
        List goods = this.pddGoodsIntegration.queryGoodsList(goodsQueryRo);
        if (goods == null) {
            return null;
        }
        return goods.stream().map(this::trans2Vo).collect(Collectors.toList());
    }

    private GoodVo trans2Vo(Good good) {
        GoodVo goodVo = new GoodVo();
        goodVo.setGoodsId(good.getGoodsId().toString());
        goodVo.setGoodsName(good.getGoodsName());
        goodVo.setGoodsThumbnailUrl(good.getGoodsThumbnailUrl());
        long price = good.getMinGroupPrice() - good.getCouponDiscount();
        goodVo.setPrice(Long.valueOf(price));
        Double reappearance = CalculateUtils.divide((Number)(price * good.getPromotionRate()), (Number)1000L).doubleValue();
        goodVo.setCouponDiscount(good.getCouponDiscount());
        goodVo.setSoldQuantity(good.getSoldQuantity());
        String redisKey = String.format("MINIPROGRAM:REBATE:LIST:%s", good.getGoodsId());
        String json = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isBlank((CharSequence)json)) {
            json = (String)this.stringRedisTemplate.opsForValue().get((Object)String.format("MINIPROGRAM:REBATE:LIST:%s", 0));
        }
        if (StringUtils.isBlank((CharSequence)json)) {
            log.error("\u8fd4\u4f63\u8fd4\u5229\u914d\u7f6e\u4e3a\u7a7a");
            return goodVo;
        }
        Reappearance reappearanceRate = (Reappearance)JSONObject.parseObject((String)json, Reappearance.class);
        goodVo.setReappearance(Long.valueOf(CalculateUtils.divide((Number)(reappearance * (double)reappearanceRate.getSelfPurchase().byteValue()), (Number)100L).longValue()));
        return goodVo;
    }
}

