/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.service.impl;

import com.bxm.shop.dal.mapper.OrderMapper;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.facade.model.order.OrderVo;
import com.bxm.shop.facade.model.order.PddOrderList;
import com.bxm.shop.integration.pdd.CommonGoodsPromotionUrlIntegration;
import com.bxm.shop.integration.pdd.OrderIncrementGetIntegration;
import com.bxm.shop.model.order.dao.OrderDao;
import com.bxm.shop.service.OrderService;
import java.util.Date;
import org.dozer.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService {
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private Mapper mapper;
    @Autowired
    private CommonGoodsPromotionUrlIntegration commonGoodsPromotionUrlIntegration;
    @Autowired
    private OrderIncrementGetIntegration orderIncrementGetIntegration;

    @Override
    public OrderVo add(OrderDto dto) {
        OrderDao order = new OrderDao();
        this.mapper.map((Object)dto, (Object)order);
        order.setParentRate(30);
        order.setShareRate(10);
        order.setParentRate(5);
        order.setGrandparentRate(5);
        order.setCreateTime(new Date());
        this.orderMapper.save(order);
        OrderVo orderVo = this.commonGoodsPromotionUrlIntegration.generate(dto.getGoodsId(), order.getId() + "");
        if (null == order) {
            orderVo = new OrderVo();
        }
        orderVo.setOpenid(dto.getOpenid());
        orderVo.setOrderId(order.getId());
        orderVo.setGoodsId(order.getGoodsId());
        return orderVo;
    }

    @Override
    public void deleteAbandonOrder(Date date) {
        this.orderMapper.deleteAbandonOrder(date);
    }

    @Override
    public void synchronizeOrder(OrderDto dto) {
        PddOrderList orderListInfo = this.orderIncrementGetIntegration.getIncrementOrder(dto);
        System.out.println(orderListInfo.toString());
    }
}

