/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.dal.Tag;
import com.bxm.shop.dal.base.Example;
import com.bxm.shop.dal.mapper.TagMapper;
import com.bxm.shop.facade.model.TagVo;
import com.bxm.shop.service.TagService;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TagServiceImpl
implements TagService {
    @Resource
    private TagMapper tagMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public List<TagVo> getTagsByParentId() {
        String json = (String)this.stringRedisTemplate.opsForValue().get((Object)"MINIPROGRAM:TAG:CONFIG");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            return JSONObject.parseArray((String)json, TagVo.class);
        }
        Example<Tag> example = new Example<Tag>(){};
        List tags = this.tagMapper.selectByExample((Example)example);
        List<TagVo> result = this.treeify(tags);
        this.stringRedisTemplate.opsForValue().set((Object)"MINIPROGRAM:TAG:CONFIG", (Object)JSONObject.toJSONString(result));
        return result;
    }

    private List<TagVo> treeify(List<Tag> tags) {
        TreeMap<Long, TagVo> result = new TreeMap<Long, TagVo>(Comparator.comparingLong(a -> a));
        Iterator<Tag> iterator = tags.iterator();
        while (iterator.hasNext()) {
            Tag tag = iterator.next();
            if (tag.getParentId() != 0L && tag.getVisible().booleanValue()) continue;
            iterator.remove();
            result.put(tag.getId(), this.trans2Vo(tag));
        }
        for (Tag tag : tags) {
            TagVo tagVo2 = (TagVo)result.get(tag.getParentId());
            if (tagVo2 == null) continue;
            tagVo2.getSubTags().add(this.trans2Vo(tag));
        }
        return result.values().stream().peek(tagVo -> tagVo.getSubTags().sort(Comparator.comparingInt(TagVo::getOrder))).collect(Collectors.toList());
    }

    private TagVo trans2Vo(Tag tag) {
        TagVo tagVo = new TagVo();
        tagVo.setOptId(tag.getId());
        tagVo.setOptName(tag.getName());
        tagVo.setParentOptId(tag.getParentId());
        tagVo.setOrder(tag.getOrder());
        tagVo.setImgUrl(tag.getImageUrl());
        return tagVo;
    }
}

