/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.service.impl;

import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.common.utils.InviteCodeUtils;
import com.bxm.shop.config.WechatConfig;
import com.bxm.shop.dal.mapper.UserMapper;
import com.bxm.shop.facade.model.user.UserDto;
import com.bxm.shop.facade.model.user.UserVo;
import com.bxm.shop.model.user.dao.UserDao;
import com.bxm.shop.model.user.dto.WechatLoginReturn;
import com.bxm.shop.service.UserService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.dozer.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class UserServiceImpl
implements UserService {
    @Autowired
    private WechatConfig wechatConfig;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private Mapper mapper;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    protected Updater updater;

    @Override
    public UserVo login(UserDto dto) {
        UserVo vo = new UserVo();
        WechatLoginReturn loginObj = this.wechartLogin(dto.getCode());
        if (null == loginObj.getOpenid()) {
            return vo;
        }
        vo.setOpenid(loginObj.getOpenid());
        vo.setUnionid(loginObj.getUnioinid());
        vo.setSessionId(loginObj.getSessionkey());
        UserDao info = (UserDao)this.fetcher.hfetch(RedisConstants.User.getUserInfo(), vo.getOpenid(), UserDao.class);
        if (null == info) {
            UserDao parentUser;
            info = new UserDao();
            this.mapper.map((Object)dto, (Object)info);
            info.setCreateTime(new Date());
            info.setOpenid(vo.getOpenid());
            info.setUnionid(vo.getUnionid());
            if (StringUtils.isNotBlank((String)dto.getInviteCode()) && null != (parentUser = this.userMapper.findByInviteCode(dto.getInviteCode()))) {
                info.setParentOpenid(parentUser.getOpenid());
                info.setParentUnionid(parentUser.getUnionid());
                info.setGrandparentOpenid(parentUser.getParentOpenid());
                info.setGrandparentUnionid(parentUser.getGrandparentUnionid());
            }
            this.userMapper.svae(info);
            String inviteCode = InviteCodeUtils.generate((Long)info.getId());
            info.setInviteCode(inviteCode);
            this.userMapper.updateByOpenid(info);
        }
        this.updater.hupdate(RedisConstants.User.getUserInfo(), info.getOpenid(), (Object)info);
        this.updater.update(RedisConstants.User.getSessionId((String)vo.getOpenid(), (String)vo.getSessionId()), (Object)"", RedisConstants.User.SESSION_TIME.intValue());
        vo.setInviteCode(info.getInviteCode());
        return vo;
    }

    private WechatLoginReturn wechartLogin(String code) {
        WechatLoginReturn loginObj = new WechatLoginReturn();
        loginObj.setOpenid("testopenid2");
        loginObj.setSessionkey("testSessionKey2");
        return loginObj;
    }
}

