/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.netflix.governator.AbstractLifecycleListener;
import com.netflix.governator.LifecycleManager;
import com.netflix.governator.LoggingProvisionMetricsVisitor;
import com.netflix.governator.ProvisionMetrics;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LoggingProvisionMetricsLifecycleListener
extends AbstractLifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingProvisionMetricsLifecycleListener.class);
    private final ProvisionMetrics metrics;

    @Inject
    LoggingProvisionMetricsLifecycleListener(LifecycleManager manager, ProvisionMetrics metrics) {
        this.metrics = metrics;
        manager.addListener(this);
    }

    @Override
    public void onStarted() {
        LOG.info("Injection provision report : \n");
        this.metrics.accept(new LoggingProvisionMetricsVisitor());
    }

    @Override
    public void onStopped(Throwable t) {
        if (t != null) {
            LOG.info("Injection provision report for failed start : \n");
            this.metrics.accept(new LoggingProvisionMetricsVisitor());
        }
    }
}

