/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.integration.pdd.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.utils.JSONStringUnderscoreToCamel;
import com.bxm.shop.common.utils.OkHttpUtils;
import com.bxm.shop.common.utils.ParamEncodeUtils;
import com.bxm.shop.facade.model.order.OrderVo;
import com.bxm.shop.integration.config.PingduoduoConfig;
import com.bxm.shop.integration.pdd.CommonGoodsPromotionUrlIntegration;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonGoodsPromotionUrlIntegrationImpl
implements CommonGoodsPromotionUrlIntegration {
    private static final Logger log = LoggerFactory.getLogger(CommonGoodsPromotionUrlIntegrationImpl.class);
    @Autowired
    private PingduoduoConfig pingduoduoConfig;

    @Override
    public OrderVo generate(String goodsId, String customParam) {
        Map<String, String> param = this.pingduoduoConfig.getCommonParam();
        param.put("type", "pdd.ddk.goods.promotion.url.generate");
        param.put("p_id", this.pingduoduoConfig.getDefaultPid());
        param.put("goods_id_list", "[" + goodsId + "]");
        param.put("custom_parameters", customParam);
        param.put("generate_we_app", "true");
        String sign = ParamEncodeUtils.getMd5Signature(param, (String)this.pingduoduoConfig.getClientSecret());
        param.put("sign", sign);
        String response = null;
        try {
            JSONArray jsonArray;
            JSONObject obj;
            response = OkHttpUtils.post((String)"https://gw-api.pinduoduo.com/api/router", param);
            System.out.println(ParamEncodeUtils.unicodeToString((String)response));
            response = ParamEncodeUtils.unicodeToString((String)response);
            if (null != response && null != (obj = JSON.parseObject((String)response)) && obj.getJSONObject("goods_promotion_url_generate_response") != null && null != (jsonArray = obj.getJSONObject("goods_promotion_url_generate_response").getJSONArray("goods_promotion_url_list")) && jsonArray.size() > 0) {
                JSONObject urlObj = (JSONObject)jsonArray.get(0);
                System.out.println(urlObj.getString("we_app_info"));
                String weAppInfo = JSONStringUnderscoreToCamel.transform((String)urlObj.getString("we_app_info"));
                System.out.println(weAppInfo);
                return (OrderVo)JSON.parseObject((String)weAppInfo, OrderVo.class);
            }
        }
        catch (IOException e) {
            log.error("CommonDoodsPromotionUrlIntegrationImpl.generate  Error", (Throwable)e);
        }
        return null;
    }
}

