/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.integration.pdd.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.utils.OkHttpUtils;
import com.bxm.shop.common.utils.ParamEncodeUtils;
import com.bxm.shop.facade.model.GoodsQueryRo;
import com.bxm.shop.integration.config.PingduoduoConfig;
import com.bxm.shop.integration.pdd.PddGoodsIntegration;
import com.bxm.shop.model.Good;
import com.bxm.shop.model.GoodDetail;
import com.bxm.shop.model.GoodDetailList;
import com.bxm.shop.model.GoodsList;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PddGoodsIntegrationImpl
implements PddGoodsIntegration {
    private static final Logger log = LoggerFactory.getLogger(PddGoodsIntegrationImpl.class);
    @Resource
    private PingduoduoConfig pingduoduoConfig;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public List<Good> queryGoodsList(GoodsQueryRo goodsQueryRo) {
        String json = (String)this.stringRedisTemplate.opsForValue().get((Object)String.format("MINIPROGRAM:PDD_GOODS:LIST:%s", goodsQueryRo.hashCode()));
        if (StringUtils.isNotBlank((CharSequence)json)) {
            return JSONObject.parseArray((String)json, Good.class);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        if (goodsQueryRo.getTagId() != null) {
            param.put("opt_id", goodsQueryRo.getTagId().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)goodsQueryRo.getKeyword())) {
            param.put("keyword", goodsQueryRo.getKeyword());
        }
        if (goodsQueryRo.getGoodsIdList() != null) {
            param.put("goods_id_list", JSONObject.toJSONString((Object)goodsQueryRo.getGoodsIdList()));
        }
        param.put("page_size", goodsQueryRo.getPageSize().toString());
        param.put("page", goodsQueryRo.getPageNum().toString());
        param.put("sort_type", goodsQueryRo.getSortType().toString());
        param.put("type", "pdd.ddk.goods.search");
        param.put("with_coupon", "true");
        try {
            GoodsList goodsList = this.post(param, GoodsList.class);
            if (goodsList == null) {
                log.warn("\u67e5\u8be2\u62fc\u591a\u591a\u83b7\u53d6\u5546\u54c1\u5217\u8868\u63a5\u53e3\u8fd4\u56de\u7a7a\u503c");
                return null;
            }
            if (goodsList.getErrorResponse() != null) {
                log.warn("\u67e5\u8be2\u62fc\u591a\u591a\u83b7\u53d6\u5546\u54c1\u5217\u8868\u63a5\u53e3\u8fd4\u56de\u9519\u8bef\u4fe1\u606f{}", (Object)goodsList);
                return null;
            }
            List result = goodsList.getResponse().getGoodsList();
            this.stringRedisTemplate.opsForValue().set((Object)String.format("MINIPROGRAM:PDD_GOODS:LIST:%s", goodsQueryRo.hashCode()), (Object)JSONObject.toJSONString((Object)result), 5L, TimeUnit.MINUTES);
            return result;
        }
        catch (IOException e) {
            log.error("\u67e5\u8be2\u62fc\u591a\u591a\u83b7\u53d6\u5546\u54c1\u5217\u8868\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Good> queryGoodsList(List<String> goodsIdList) {
        GoodsQueryRo ro = new GoodsQueryRo();
        ro.setGoodsIdList(goodsIdList);
        return this.queryGoodsList(ro);
    }

    @Override
    public GoodDetail queryGoodDetail(String goodId) {
        String json = (String)this.stringRedisTemplate.opsForValue().get((Object)String.format("MINIPROGRAM:PDD_GOODS:LIST:%s", goodId));
        if (StringUtils.isNotBlank((CharSequence)json)) {
            return (GoodDetail)JSONObject.parseObject((String)json, GoodDetail.class);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        String[] goodIds = new String[]{goodId};
        param.put("goods_id_list", JSONObject.toJSONString((Object)goodIds));
        param.put("type", "pdd.ddk.goods.detail");
        try {
            GoodDetailList goodDetailList = this.post(param, GoodDetailList.class);
            if (goodDetailList != null && goodDetailList.getResponse() != null && goodDetailList.getResponse().getGoodsDetails() != null && goodDetailList.getResponse().getGoodsDetails().size() > 0) {
                GoodDetail result = (GoodDetail)goodDetailList.getResponse().getGoodsDetails().get(0);
                this.stringRedisTemplate.opsForValue().set((Object)String.format("MINIPROGRAM:PDD_GOODS:LIST:%s", goodId), (Object)JSONObject.toJSONString((Object)result), 5L, TimeUnit.MINUTES);
                return result;
            }
        }
        catch (IOException e) {
            log.error("\u67e5\u8be2\u62fc\u591a\u591a\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
        }
        return null;
    }

    private <T> T post(Map<String, String> param, Class<T> clazz) throws IOException {
        param.put("timestamp", String.valueOf(System.currentTimeMillis()).substring(0, 10));
        param.put("client_id", this.pingduoduoConfig.getClientId());
        String signature = ParamEncodeUtils.getMd5Signature(param, (String)this.pingduoduoConfig.getClientSecret());
        param.put("sign", signature);
        String s = OkHttpUtils.post((String)"https://gw-api.pinduoduo.com/api/router", param);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return (T)JSONObject.parseObject((String)s, clazz);
        }
        return null;
    }
}

