#!/bin/bash

ACTIVE="$1"
if [ -z "$ACTIVE" ]; then
  ACTIVE="production"
  echo "Use default profile: $ACTIVE"
fi

[ ! -d ~/run/ ] && mkdir -p ~/run

if [ -f ~/run/shops-service.pid ]; then
  echo "Server [shops-service] pid file has been exists!";
  exit
fi

HEAP_MEMORY=3g
SERVER_JAR=`ls ../lib/shops-service-1.0.0-SNAPSHOT.jar`

exec "${JAVA_HOME}/bin/java" -server -Dspring.profiles.active=$ACTIVE -Xms${HEAP_MEMORY} -Xmx${HEAP_MEMORY} -XX:+HeapDumpOnOutOfMemoryError -jar ${SERVER_JAR} >/dev/null 2>&1 & echo $! > ~/run/shops-service.pid