#!/bin/bash

if [ ! -f ~/run/shops-service.pid ]; then
  echo "Server [shops-service] doest not started!"
  exit
fi

pid=`cat ~/run/shops-service.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in shops-service.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [shops-service] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [shops-service] cannot stop, Please check pid file 'shops-service.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [shops-service] has been stoped!"
fi

rm -f ~/run/shops-service.pid