/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.jobs;

import com.bxm.shop.common.utils.ExceptionPrintUtils;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.integration.OrderServiceIntegration;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SynchronizeOrderJob {
    private static final Logger log = LoggerFactory.getLogger(SynchronizeOrderJob.class);
    @Autowired
    private MessageSender messageSender;
    @Autowired
    private OrderServiceIntegration orderServiceIntegration;

    @Scheduled(cron="0/10 * * * * ?")
    public void synchronizeOrder() {
        OrderDto dto = new OrderDto();
        dto.setStartUpdateTime(Long.valueOf(System.currentTimeMillis() / 1000L - 1728000L));
        dto.setEndUpdateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
        dto.setPageSize(Integer.valueOf(50));
        dto.setPageNum(Integer.valueOf(1));
        try {
            this.orderServiceIntegration.synchronizeOrder(dto);
        }
        catch (Exception e) {
            Message msg = new Message();
            msg.setContent("synchronizeOrder Error:" + ExceptionPrintUtils.printStackTraceToString((Throwable)e));
            this.messageSender.send2(msg);
            log.error("synchronizeOrder error", (Throwable)e);
        }
    }
}

