package com.bxm.spider.deal.integration;

import com.bxm.spider.deal.facade.service.RepeatCacheFacadeService;
import com.bxm.spider.response.ResponseModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * <p> 处理中心相关服务 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/1/10
 */
@Service
public class DealIntegration {
    private final Logger LOG = LoggerFactory.getLogger(DealIntegration.class);

    @Autowired
    private RepeatCacheFacadeService repeatCacheService;

    public Map<String,Integer> initializeSimHash(){
        ResponseModel<Map<String,Integer>> result = repeatCacheService.initializeSimHash();
        if(result.isSuccess()){
            return result.getData();
        } else {
            LOG.error("sinHash初始化失败，message:{}",result.getMessage());
            return null;
        }
    }

    public Map<String,Integer> countSimHashCache(){
        ResponseModel<Map<String,Integer>> result = repeatCacheService.countSimHashCache();
        if(result.isSuccess()){
            return result.getData();
        } else {
            LOG.error("sinHash初始化失败，message:{}",result.getMessage());
            return null;
        }
    }
}
