package com.bxm.spider.manager.dal.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.bxm.spider.manager.model.dao.SpiderMonitorReport;
import com.bxm.spider.manager.model.dto.SpiderMonitorReportDto;
import com.bxm.spider.manager.model.vo.SpiderMonitorReportVo;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * <p>
 * 爬虫监控报表 Mapper 接口
 * </p>
 *
 * @author stephen
 * @since 2018-12-20
 */
@Repository
public interface SpiderMonitorReportMapper extends BaseMapper<SpiderMonitorReport> {

    /**
     * 根据条件查询站点列表
     *
     * @param spiderMonitorReportDto
     * @return
     */
    List<SpiderMonitorReportVo> getSiteList(SpiderMonitorReportDto spiderMonitorReportDto);

    /**
     * 根据条件查询应用列表
     *
     * @param spiderMonitorReportDto
     * @return
     */
    List<SpiderMonitorReportVo> getAppList(SpiderMonitorReportDto spiderMonitorReportDto);

    /**
     * 根据流水号查询报表
     *
     * @param spiderMonitorReportDto
     * @return
     */
    List<SpiderMonitorReportVo> getReportBySerialNum(SpiderMonitorReportDto spiderMonitorReportDto);

}
