package com.bxm.spider.manager.dal.mapper;

import com.bxm.spider.manager.model.dto.SpiderReportDto;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 爬虫报表 Mapper 接口
 * </p>
 *
 * @author stephen
 * @since 2019-01-16
 */
@Repository
public interface SpiderReportMapper {

    /**
     * 查询区域报表数据
     *
     * @param spiderReportDto
     * @return
     */
    List<Map<String, Object>> getAreaReport(SpiderReportDto spiderReportDto);

    /**
     * 查询新闻站点数据
     *
     * @param spiderReportDto
     * @return
     */
    List<Map<String, Object>> getNewsSiteReport(SpiderReportDto spiderReportDto);

    /**
     * 查询微信新闻公众号数据
     *
     * @param spiderReportDto
     * @return
     */
    List<Map<String, Object>> getWechatNewsAccountReport(SpiderReportDto spiderReportDto);

}
