/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.config;

import com.bxm.spider.response.ResponseModel;
import com.bxm.spider.response.ResponseModelFactory;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;

@Component
@ControllerAdvice
public class ControllerExceptionHandler {
    private static final Integer DEFAULT_ERROR_CODE = -1;
    private Logger logger = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseModel exceptionHandler(Exception e) {
        this.logger.error("Exception error", (Throwable)e);
        return ResponseModelFactory.FAILED((Integer)DEFAULT_ERROR_CODE, (String)e.getMessage());
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), true));
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"), true));
    }
}

