/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.controller;

import com.bxm.spider.manager.facade.model.CommodityDetailDTO;
import com.bxm.spider.manager.facade.model.CommodityImageDTO;
import com.bxm.spider.manager.facade.model.ResponseJson;
import com.bxm.spider.manager.service.service.TaobaoService;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/taobao"})
public class TaobaoController {
    @Autowired
    private TaobaoService taobaoService;

    @RequestMapping(value={"/goods/{goodsId}"}, method={RequestMethod.GET})
    public ResponseJson<CommodityDetailDTO> taobaoGoodsInfo(@PathVariable(value="goodsId") Long goodsId) {
        CommodityDetailDTO commodityDetailDTO = this.taobaoService.info(goodsId);
        return null == commodityDetailDTO ? ResponseJson.serverError() : ResponseJson.ok((Object)commodityDetailDTO);
    }

    @RequestMapping(value={"/goods/detail/{goodsId}"}, method={RequestMethod.GET})
    public ResponseJson<List<CommodityImageDTO>> taobaoGoodsDetail(@PathVariable(value="goodsId") Long goodsId) {
        List imgs = this.taobaoService.detail(goodsId);
        return CollectionUtils.isEmpty((Collection)imgs) ? ResponseJson.serverError() : ResponseJson.ok((Object)imgs);
    }
}

