/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.spider.manager.model.dao.UrlRuler;
import com.bxm.spider.manager.model.dto.UrlRulerDto;
import com.bxm.spider.manager.service.service.UrlConfigService;
import com.bxm.spider.manager.service.service.UrlRulerService;
import com.bxm.spider.response.ResponseModel;
import com.bxm.spider.response.ResponseModelFactory;
import com.bxm.spider.utils.HttpUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u914d\u7f6e-\u89c4\u5219\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/ruler"})
public class UrlRulerController {
    private Logger logger = LoggerFactory.getLogger(UrlRulerController.class);
    @Autowired
    private UrlRulerService urlRulerService;
    @Autowired
    private UrlConfigService urlConfigService;

    @ApiOperation(value="\u65b0\u589e")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> add(@RequestBody UrlRuler urlRuler) {
        urlRuler.setEscapeHtml(StringUtils.isEmpty((CharSequence)urlRuler.getEscapeHtml()) ? "0" : urlRuler.getEscapeHtml());
        return ResponseModelFactory.SUCCESS((Object)this.urlRulerService.insert((Object)urlRuler));
    }

    @ApiOperation(value="\u6279\u91cf\u65b0\u589e")
    @RequestMapping(value={"/addBatch"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> addBatch(@RequestBody List<UrlRuler> urlRulerList) {
        return ResponseModelFactory.SUCCESS((Object)this.urlRulerService.insertBatch(urlRulerList));
    }

    @ApiOperation(value="\u4fee\u6539")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> update(@RequestBody UrlRuler urlRuler) {
        urlRuler.setModifyTime(new Date());
        return ResponseModelFactory.SUCCESS((Object)this.urlRulerService.updateById((Object)urlRuler));
    }

    @ApiOperation(value="\u5220\u9664")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> delete(@RequestBody UrlRuler urlRuler) {
        UrlRuler ruler = (UrlRuler)this.urlRulerService.selectById((Serializable)urlRuler.getId());
        String site = ruler.getSite();
        List urlConfigList = this.urlConfigService.selectList(new EntityWrapper().eq("ruler_site", (Object)site));
        if (CollectionUtils.isNotEmpty((Collection)urlConfigList)) {
            return ResponseModelFactory.FAILED((Integer)ResponseModelFactory.ResponseCode.SYSTEM_ERROR.getCode(), (String)"\u89c4\u5219\u6b63\u5728\u88ab\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        return ResponseModelFactory.SUCCESS((Object)this.urlRulerService.deleteById((Serializable)urlRuler.getId()));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/selectPage"}, method={RequestMethod.GET})
    public ResponseModel<Page<UrlRuler>> selectPage(HttpServletRequest request, @ModelAttribute UrlRulerDto urlRulerDto) {
        String ip = HttpUtils.getIpFromHeader((HttpServletRequest)request);
        this.logger.info(ip);
        return ResponseModelFactory.SUCCESS((Object)this.urlRulerService.selectPage(urlRulerDto));
    }

    @ApiOperation(value="\u67e5\u8be2")
    @RequestMapping(value={"/selectById"}, method={RequestMethod.GET})
    public ResponseModel<UrlRuler> selectById(@ModelAttribute UrlRulerDto urlRulerDto) {
        return ResponseModelFactory.SUCCESS((Object)this.urlRulerService.selectById((Serializable)urlRulerDto.getId()));
    }
}

