/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.bxm.spider.constant.task.TaskStatusEnum;
import com.bxm.spider.manager.model.dao.UrlTask;
import com.bxm.spider.manager.model.dto.UrlTaskDto;
import com.bxm.spider.manager.service.service.UrlTaskService;
import com.bxm.spider.manager.service.util.PriderUtil;
import com.bxm.spider.response.ResponseModel;
import com.bxm.spider.response.ResponseModelFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u914d\u7f6e-\u4efb\u52a1\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/task"})
public class UrlTaskController {
    @Autowired
    private UrlTaskService urlTaskService;

    @ApiOperation(value="\u65b0\u589e")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> add(@RequestBody UrlTask urlTask) {
        String serialNum = PriderUtil.getSerialNum();
        urlTask.setSerialNum(serialNum);
        return ResponseModelFactory.SUCCESS((Object)this.urlTaskService.insert((Object)urlTask));
    }

    @ApiOperation(value="\u4fee\u6539")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> update(@RequestBody UrlTask urlTask) {
        urlTask.setModifyTime(new Date());
        UrlTask task = (UrlTask)this.urlTaskService.selectById((Serializable)urlTask.getId());
        int executeStatus = task.getExecuteStatus();
        if (TaskStatusEnum.RUNNING.getCode() == executeStatus || TaskStatusEnum.PAUSE.getCode() == executeStatus) {
            return ResponseModelFactory.FAILED((Integer)ResponseModelFactory.ResponseCode.SYSTEM_ERROR.getCode(), (String)("\u4ec5\u80fd\u4fee\u6539 " + TaskStatusEnum.WAIT_START.getName() + " \u4e0e " + TaskStatusEnum.STOP.getName() + " \u72b6\u6001\u7684\u4efb\u52a1"));
        }
        return ResponseModelFactory.SUCCESS((Object)this.urlTaskService.updateById((Object)urlTask));
    }

    @ApiOperation(value="\u5220\u9664")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> delete(@RequestBody UrlTask urlTask) {
        UrlTask task = (UrlTask)this.urlTaskService.selectById((Serializable)urlTask.getId());
        int executeStatus = task.getExecuteStatus();
        if (TaskStatusEnum.RUNNING.getCode() == executeStatus || TaskStatusEnum.PAUSE.getCode() == executeStatus) {
            return ResponseModelFactory.FAILED((Integer)ResponseModelFactory.ResponseCode.SYSTEM_ERROR.getCode(), (String)("\u4ec5\u80fd\u5220\u9664 " + TaskStatusEnum.WAIT_START.getName() + " \u4e0e " + TaskStatusEnum.STOP.getName() + " \u72b6\u6001\u7684\u4efb\u52a1"));
        }
        return ResponseModelFactory.SUCCESS((Object)this.urlTaskService.deleteById((Serializable)urlTask.getId()));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/selectPage"}, method={RequestMethod.GET})
    public ResponseModel<Page<UrlTask>> selectPage(@ModelAttribute UrlTaskDto urlTaskDto) {
        return ResponseModelFactory.SUCCESS((Object)this.urlTaskService.selectPage(urlTaskDto));
    }

    @ApiOperation(value="\u67e5\u8be2\u4e00\u6761")
    @RequestMapping(value={"/selectById"}, method={RequestMethod.GET})
    public ResponseModel<UrlTask> selectById(@ModelAttribute UrlTaskDto urlTaskDto) {
        return ResponseModelFactory.SUCCESS((Object)this.urlTaskService.selectById((Serializable)urlTaskDto.getId()));
    }
}

