/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.constant.processor.FilterStrategyContent;
import com.bxm.spider.constant.processor.FilterTypeEnum;
import com.bxm.spider.manager.dal.mapper.FilterStrategyMapper;
import com.bxm.spider.manager.model.dao.FilterStrategy;
import com.bxm.spider.manager.model.dto.FilterStrategyDto;
import com.bxm.spider.manager.service.service.FilterStrategyService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilterStrategyServiceImpl
extends ServiceImpl<FilterStrategyMapper, FilterStrategy>
implements FilterStrategyService {
    @Autowired
    private RedisClient redisClient;

    public boolean insert(FilterStrategy filterStrategy) {
        super.insert((Object)filterStrategy);
        EntityWrapper wrapper = new EntityWrapper();
        wrapper.eq("filter_content_type", (Object)filterStrategy.getFilterContentType());
        wrapper.eq("filter_type", (Object)filterStrategy.getFilterType());
        wrapper.eq("state", (Object)1);
        List filterStrategyList = super.selectList((Wrapper)wrapper);
        this.redisClient.hSet("FILTER", filterStrategy.getFilterContentType() + ":" + filterStrategy.getFilterType(), JSON.toJSONString((Object)filterStrategyList));
        return true;
    }

    public boolean update(FilterStrategy filterStrategy) {
        super.updateById((Object)filterStrategy);
        EntityWrapper wrapper = new EntityWrapper();
        wrapper.eq("filter_content_type", (Object)filterStrategy.getFilterContentType());
        wrapper.eq("filter_type", (Object)filterStrategy.getFilterType());
        wrapper.eq("state", (Object)1);
        List filterStrategyList = super.selectList((Wrapper)wrapper);
        this.redisClient.hSet("FILTER", filterStrategy.getFilterContentType() + ":" + filterStrategy.getFilterType(), JSON.toJSONString((Object)filterStrategyList));
        return true;
    }

    public boolean delete(Long id) {
        FilterStrategy filterStrategy = (FilterStrategy)super.selectById((Serializable)id);
        super.deleteById((Serializable)id);
        EntityWrapper wrapper = new EntityWrapper();
        wrapper.eq("filter_content_type", (Object)filterStrategy.getFilterContentType());
        wrapper.eq("filter_type", (Object)filterStrategy.getFilterType());
        wrapper.eq("state", (Object)1);
        List filterStrategyList = super.selectList((Wrapper)wrapper);
        this.redisClient.hSet("FILTER", filterStrategy.getFilterContentType() + ":" + filterStrategy.getFilterType(), JSON.toJSONString((Object)filterStrategyList));
        return true;
    }

    public Page<FilterStrategy> selectPage(FilterStrategyDto filterStrategyDto) {
        Page page = new Page();
        page.setCurrent(filterStrategyDto.getPageNum().intValue());
        page.setSize(filterStrategyDto.getPageSize().intValue());
        EntityWrapper entityWrapper = new EntityWrapper();
        entityWrapper.orderBy("modify_time", false);
        if (StringUtils.isNotEmpty((CharSequence)filterStrategyDto.getFilterContent())) {
            entityWrapper.like("filter_content", filterStrategyDto.getFilterContent());
        }
        if (filterStrategyDto.getFilterContentType() != null) {
            entityWrapper.eq("filter_content_type", (Object)filterStrategyDto.getFilterContentType());
        }
        if (filterStrategyDto.getFilterType() != null) {
            entityWrapper.eq("filter_type", (Object)filterStrategyDto.getFilterType());
        }
        if (filterStrategyDto.getState() != null) {
            entityWrapper.eq("state", (Object)filterStrategyDto.getState());
        }
        return super.selectPage(page, (Wrapper)entityWrapper);
    }

    public boolean refresh() {
        List filterStrategyList;
        EntityWrapper wrapper;
        for (FilterTypeEnum filterTypeEnum : FilterTypeEnum.values()) {
            wrapper = new EntityWrapper();
            wrapper.eq("filter_content_type", (Object)FilterStrategyContent.TITLE);
            wrapper.eq("filter_type", (Object)filterTypeEnum.getCode());
            wrapper.eq("state", (Object)1);
            filterStrategyList = super.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isNotEmpty((Collection)filterStrategyList)) continue;
            this.redisClient.hSet("FILTER", FilterStrategyContent.TITLE + ":" + filterTypeEnum.getCode(), JSON.toJSONString((Object)filterStrategyList));
        }
        for (FilterTypeEnum filterTypeEnum : FilterTypeEnum.values()) {
            wrapper = new EntityWrapper();
            wrapper.eq("filter_content_type", (Object)FilterStrategyContent.CONTENT);
            wrapper.eq("filter_type", (Object)filterTypeEnum.getCode());
            wrapper.eq("state", (Object)1);
            filterStrategyList = super.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isNotEmpty((Collection)filterStrategyList)) continue;
            this.redisClient.hSet("FILTER", FilterStrategyContent.CONTENT + ":" + filterTypeEnum.getCode(), JSON.toJSONString((Object)filterStrategyList));
        }
        return true;
    }
}

