/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.plugins.pagination.PageHelper;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.bxm.spider.constant.monitor.ErrorEnum;
import com.bxm.spider.constant.monitor.SiteTypeEnum;
import com.bxm.spider.constant.url.UrlTypeEnum;
import com.bxm.spider.manager.dal.mapper.SpiderExceptionMonitorMapper;
import com.bxm.spider.manager.dal.mapper.SpiderMonitorReportMapper;
import com.bxm.spider.manager.model.dto.SpiderMonitorReportDto;
import com.bxm.spider.manager.model.vo.SpiderExceptionMonitorVo;
import com.bxm.spider.manager.model.vo.SpiderMonitorReportVo;
import com.bxm.spider.manager.service.service.MonitorReportService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitorReportServiceImpl
implements MonitorReportService {
    @Autowired
    private SpiderMonitorReportMapper spiderMonitorReportMapper;
    @Autowired
    private SpiderExceptionMonitorMapper spiderExceptionMonitorMapper;

    public Page<SpiderMonitorReportVo> getSitePageList(SpiderMonitorReportDto spiderMonitorReportDto) {
        this.checkFieldEmpty((Object)spiderMonitorReportDto);
        spiderMonitorReportDto.setSiteType(this.getSiteTypeEnumByName(spiderMonitorReportDto.getSiteType()));
        PageHelper.startPage((int)spiderMonitorReportDto.getPageNum(), (int)spiderMonitorReportDto.getPageSize());
        List resultList = this.spiderMonitorReportMapper.getSiteList(spiderMonitorReportDto);
        this.calExtraColumn(resultList);
        Page resultPage = new Page();
        Pagination pagination = PageHelper.getPagination();
        resultPage.setCurrent(pagination.getCurrent());
        resultPage.setSize(pagination.getSize());
        resultPage.setTotal(pagination.getTotal());
        resultPage.setRecords(resultList);
        return resultPage;
    }

    public Page<SpiderMonitorReportVo> getAppPageList(SpiderMonitorReportDto spiderMonitorReportDto) {
        this.checkFieldEmpty((Object)spiderMonitorReportDto);
        spiderMonitorReportDto.setSiteType(this.getSiteTypeEnumByName(spiderMonitorReportDto.getSiteType()));
        PageHelper.startPage((int)spiderMonitorReportDto.getPageNum(), (int)spiderMonitorReportDto.getPageSize());
        List resultList = this.spiderMonitorReportMapper.getAppList(spiderMonitorReportDto);
        this.calExtraColumn(resultList);
        Page resultPage = new Page();
        Pagination pagination = PageHelper.getPagination();
        resultPage.setCurrent(pagination.getCurrent());
        resultPage.setSize(pagination.getSize());
        resultPage.setTotal(pagination.getTotal());
        resultPage.setRecords(resultList);
        return resultPage;
    }

    public Page<SpiderExceptionMonitorVo> getErrorPageList(SpiderMonitorReportDto spiderMonitorReportDto) {
        String[] flowArr;
        this.checkFieldEmpty((Object)spiderMonitorReportDto);
        spiderMonitorReportDto.setSiteType(this.getSiteTypeEnumByName(spiderMonitorReportDto.getSiteType()));
        if (StringUtils.isNotBlank((CharSequence)spiderMonitorReportDto.getFlowCodes()) && (flowArr = spiderMonitorReportDto.getFlowCodes().split(",")).length > 0) {
            ArrayList flowList = new ArrayList();
            boolean isDealProgress = false;
            boolean hasList = false;
            boolean hasDetail = false;
            for (String flowCode : flowArr) {
                if ("DEAL_LIST".equals(flowCode)) {
                    isDealProgress = true;
                    hasList = true;
                    continue;
                }
                if ("DEAL_DETAIL".equals(flowCode)) {
                    isDealProgress = true;
                    hasDetail = true;
                    continue;
                }
                flowList.add(flowCode);
            }
            if (isDealProgress) {
                flowList.add("DEAL_PROGRESS");
            }
            if (hasList && !hasDetail) {
                spiderMonitorReportDto.setUrlType(UrlTypeEnum.URL_LIST.name());
            } else if (!hasList && hasDetail) {
                spiderMonitorReportDto.setUrlType(UrlTypeEnum.URL_DETAIL.name());
            }
            spiderMonitorReportDto.setFlowCodeList((List)flowList);
        }
        PageHelper.startPage((int)spiderMonitorReportDto.getPageNum(), (int)spiderMonitorReportDto.getPageSize());
        List resultList = this.spiderExceptionMonitorMapper.getErrorList(spiderMonitorReportDto);
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            for (SpiderExceptionMonitorVo spiderExceptionMonitor : resultList) {
                spiderExceptionMonitor.setErrorMessage(this.getErrorEnumByCode(spiderExceptionMonitor.getErrorCode()));
            }
        }
        Page resultPage = new Page();
        Pagination pagination = PageHelper.getPagination();
        resultPage.setCurrent(pagination.getCurrent());
        resultPage.setSize(pagination.getSize());
        resultPage.setTotal(pagination.getTotal());
        resultPage.setRecords(resultList);
        return resultPage;
    }

    public Page<SpiderMonitorReportVo> getReportBySerialNum(SpiderMonitorReportDto spiderMonitorReportDto) {
        PageHelper.startPage((int)spiderMonitorReportDto.getPageNum(), (int)spiderMonitorReportDto.getPageSize());
        List resultList = this.spiderMonitorReportMapper.getReportBySerialNum(spiderMonitorReportDto);
        Page resultPage = new Page();
        Pagination pagination = PageHelper.getPagination();
        resultPage.setCurrent(pagination.getCurrent());
        resultPage.setSize(pagination.getSize());
        resultPage.setTotal(pagination.getTotal());
        resultPage.setRecords(resultList);
        return resultPage;
    }

    private void calExtraColumn(List<SpiderMonitorReportVo> resultList) {
        if (CollectionUtils.isNotEmpty(resultList)) {
            for (SpiderMonitorReportVo spiderMonitorReport : resultList) {
                if (spiderMonitorReport.getProdStart() != 0) {
                    spiderMonitorReport.setProdSuccessRate(spiderMonitorReport.getProdEnd() * 100 / spiderMonitorReport.getProdStart() + "%");
                }
                if (spiderMonitorReport.getDownloadStart() != 0) {
                    spiderMonitorReport.setDownloadSuccessRate(spiderMonitorReport.getDownloadEnd() * 100 / spiderMonitorReport.getDownloadStart() + "%");
                }
                if (spiderMonitorReport.getDealStart() != 0) {
                    spiderMonitorReport.setDealSuccessRate(spiderMonitorReport.getDealEnd() * 100 / spiderMonitorReport.getDealStart() + "%");
                }
                if (spiderMonitorReport.getSaveStart() != 0) {
                    spiderMonitorReport.setSaveSuccessRate(spiderMonitorReport.getSaveEnd() * 100 / spiderMonitorReport.getSaveStart() + "%");
                }
                spiderMonitorReport.setSiteType(this.getSiteTypeEnumByCode(spiderMonitorReport.getSiteType()));
            }
        }
    }

    private void checkFieldEmpty(Object object) {
        try {
            Field[] fields;
            Class<?> clazz = object.getClass();
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Object o = field.get(object);
                if (!"".equals(o)) continue;
                field.set(object, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getSiteTypeEnumByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        for (SiteTypeEnum ste : SiteTypeEnum.values()) {
            if (!code.equals(ste.getCode())) continue;
            return ste.getName();
        }
        return code;
    }

    private String getSiteTypeEnumByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        for (SiteTypeEnum ste : SiteTypeEnum.values()) {
            if (!name.equals(ste.getName())) continue;
            return ste.getCode();
        }
        return name;
    }

    private String getErrorEnumByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        for (ErrorEnum error : ErrorEnum.values()) {
            if (!code.equals(error.getCode())) continue;
            return error.getName();
        }
        return code;
    }
}

