/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.service.impl;

import com.bxm.spider.deal.facade.model.PageDealVo;
import com.bxm.spider.manager.facade.model.PageContentVo;
import com.bxm.spider.manager.facade.model.PageDownloadDto;
import com.bxm.spider.manager.integration.prod.service.ContentDealIntegrationService;
import com.bxm.spider.manager.integration.prod.service.DownloadIntegrationService;
import com.bxm.spider.manager.service.service.SpiderDownloadService;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpiderDownloadServiceImpl
implements SpiderDownloadService {
    private static final Logger logger = LoggerFactory.getLogger(SpiderDownloadServiceImpl.class);
    @Autowired
    DownloadIntegrationService downloadIntegrationService;
    @Autowired
    ContentDealIntegrationService dealIntegrationService;

    public PageContentVo pageDownload(PageDownloadDto pageDownloadDto) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u3010\u5355\u9875\u4e0b\u8f7d\u3011\u5f00\u59cb,\u4e0b\u8f7d\u94fe\u63a5\u4e3a:{},\u9009\u62e9\u5668\u4e3a:{}", (Object)pageDownloadDto.getUrl(), (Object)pageDownloadDto.getSelector());
        }
        PageContentVo pageContentVo = new PageContentVo();
        String content = this.downloadIntegrationService.pageDownload(pageDownloadDto.getUrl(), false);
        if (StringUtils.isBlank((CharSequence)content)) {
            pageContentVo.setContent("\u3010\u4e0b\u8f7d\u5931\u8d25\u3011\uff0c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u94fe\u63a5\u4e3a:" + pageDownloadDto.getUrl());
            return pageContentVo;
        }
        PageDealVo pageModel = this.dealIntegrationService.dealPage(content, pageDownloadDto.getSelector());
        if (Objects.isNull(pageModel)) {
            pageContentVo.setContent("\u3010\u5904\u7406\u5931\u8d25\u3011\uff0c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u94fe\u63a5\u4e3a:" + pageDownloadDto.getUrl());
            return pageContentVo;
        }
        pageContentVo.setContent(pageModel.getContent());
        pageContentVo.setHeadImages(pageModel.getHeadImages());
        return pageContentVo;
    }
}

