/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.bxm.spider.constant.task.TaskStatusEnum;
import com.bxm.spider.manager.integration.prod.service.TaskFeignIntegrationService;
import com.bxm.spider.manager.model.dao.UrlTask;
import com.bxm.spider.manager.service.service.SpiderExecuteService;
import com.bxm.spider.manager.service.service.UrlTaskService;
import com.bxm.spider.prod.facade.model.dto.TaskDto;
import com.bxm.spider.response.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpiderExecuteServiceImpl
implements SpiderExecuteService {
    @Autowired
    private TaskFeignIntegrationService taskFeignIntegrationService;
    @Autowired
    private UrlTaskService urlTaskService;

    public ResponseModel<Boolean> start(TaskDto taskDto) {
        ResponseModel responseModel = this.taskFeignIntegrationService.start(taskDto);
        if (((Boolean)responseModel.getData()).booleanValue()) {
            this.updateTaskStatus(TaskStatusEnum.RUNNING.getCode(), taskDto.getSerialNum());
        }
        return responseModel;
    }

    public ResponseModel<Boolean> pause(TaskDto taskDto) {
        ResponseModel responseModel = this.taskFeignIntegrationService.pause(taskDto);
        if (((Boolean)responseModel.getData()).booleanValue()) {
            this.updateTaskStatus(TaskStatusEnum.PAUSE.getCode(), taskDto.getSerialNum());
        }
        return responseModel;
    }

    public ResponseModel<Boolean> resume(TaskDto taskDto) {
        ResponseModel responseModel = this.taskFeignIntegrationService.resume(taskDto);
        if (((Boolean)responseModel.getData()).booleanValue()) {
            this.updateTaskStatus(TaskStatusEnum.RUNNING.getCode(), taskDto.getSerialNum());
        }
        return responseModel;
    }

    public ResponseModel<Boolean> stop(TaskDto taskDto) {
        ResponseModel responseModel = this.taskFeignIntegrationService.stop(taskDto);
        if (((Boolean)responseModel.getData()).booleanValue()) {
            this.updateTaskStatus(TaskStatusEnum.STOP.getCode(), taskDto.getSerialNum());
        }
        return responseModel;
    }

    public ResponseModel<Boolean> restartAll() {
        return this.taskFeignIntegrationService.restartAll();
    }

    private boolean updateTaskStatus(Integer status, String serialNum) {
        UrlTask urlTask = new UrlTask();
        urlTask.setExecuteStatus(status);
        return this.urlTaskService.update((Object)urlTask, new EntityWrapper().eq("serial_num", (Object)serialNum));
    }
}

