/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.plugins.pagination.PageHelper;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.bxm.spider.manager.dal.mapper.SpiderReportMapper;
import com.bxm.spider.manager.model.dto.SpiderReportDto;
import com.bxm.spider.manager.model.vo.SpiderReportVo;
import com.bxm.spider.manager.service.service.SpiderReportService;
import com.bxm.spider.utils.DateUtils;
import com.bxm.spider.utils.ExportUtils;
import com.bxm.spider.utils.MultiTableUtils;
import com.bxm.spider.utils.dto.ExportDataRow;
import com.bxm.spider.utils.dto.ExportModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpiderReportServiceImpl
implements SpiderReportService {
    private static final Logger logger = LoggerFactory.getLogger(SpiderReportServiceImpl.class);
    @Autowired
    private SpiderReportMapper spiderReportMapper;

    public Page<SpiderReportVo> getAreaReport(SpiderReportDto spiderReportDto, boolean containsNews, boolean containsWechatNews) throws Exception {
        Page resultPage = new Page();
        this.dealTime(spiderReportDto);
        if (!containsNews && !containsWechatNews) {
            return resultPage;
        }
        ArrayList tableList = new ArrayList();
        if (containsNews) {
            tableList.addAll(MultiTableUtils.getNewsTableList());
        }
        if (containsWechatNews) {
            tableList.addAll(MultiTableUtils.getFullWechatNewsTableList());
        }
        spiderReportDto.setTableList(tableList);
        PageHelper.startPage((int)spiderReportDto.getPageNum(), (int)spiderReportDto.getPageSize());
        List resultList = this.spiderReportMapper.getAreaReport(spiderReportDto);
        Pagination pagination = PageHelper.getPagination();
        resultPage.setCurrent(pagination.getCurrent());
        resultPage.setSize(pagination.getSize());
        resultPage.setTotal(pagination.getTotal());
        this.setResultPageData(resultPage, spiderReportDto.getDateList(), resultList, false, false);
        return resultPage;
    }

    public Boolean exportAreaReport(SpiderReportDto spiderReportDto, boolean containsNews, boolean containsWechatNews, HttpServletResponse response) throws Exception {
        this.dealTime(spiderReportDto);
        if (!containsNews && !containsWechatNews) {
            return false;
        }
        ArrayList tableList = new ArrayList();
        if (containsNews) {
            tableList.addAll(MultiTableUtils.getNewsTableList());
        }
        if (containsWechatNews) {
            tableList.addAll(MultiTableUtils.getFullWechatNewsTableList());
        }
        spiderReportDto.setTableList(tableList);
        List resultList = this.spiderReportMapper.getAreaReport(spiderReportDto);
        try {
            String fileName = "\u5fae\u4fe1\u65b0\u95fb\u533a\u57df\u7edf\u8ba1\u6570\u636e.xls";
            StringBuffer headNames = new StringBuffer("\u5730\u533a,\u5730\u533a\u7f16\u7801,");
            for (String date : spiderReportDto.getDateList()) {
                headNames.append(date);
                headNames.append(",");
            }
            headNames.append("\u603b\u8ba1");
            ExportModel exportModel = this.makeDataReportModel(resultList, headNames.toString(), spiderReportDto.getDateList(), false, false);
            byte[] result = ExportUtils.makeExcel((ExportModel)exportModel, (String)fileName);
            ExportUtils.exportToResponse((HttpServletResponse)response, (String)fileName, (byte[])result, (String)"excel");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5fae\u4fe1\u65b0\u95fb\u533a\u57df\u62a5\u8868\u9519\u8bef\uff1a", (Throwable)e);
            return false;
        }
        return true;
    }

    public Page<SpiderReportVo> getNewsSiteReport(SpiderReportDto spiderReportDto) throws Exception {
        Page resultPage = new Page();
        this.dealTime(spiderReportDto);
        spiderReportDto.setTableList(MultiTableUtils.getNewsTableList());
        PageHelper.startPage((int)spiderReportDto.getPageNum(), (int)spiderReportDto.getPageSize());
        List resultList = this.spiderReportMapper.getNewsSiteReport(spiderReportDto);
        Pagination pagination = PageHelper.getPagination();
        resultPage.setCurrent(pagination.getCurrent());
        resultPage.setSize(pagination.getSize());
        resultPage.setTotal(pagination.getTotal());
        this.setResultPageData(resultPage, spiderReportDto.getDateList(), resultList, true, false);
        return resultPage;
    }

    public Boolean exportNewsSiteReport(SpiderReportDto spiderReportDto, HttpServletResponse response) throws Exception {
        this.dealTime(spiderReportDto);
        spiderReportDto.setTableList(MultiTableUtils.getNewsTableList());
        List resultList = this.spiderReportMapper.getNewsSiteReport(spiderReportDto);
        try {
            String fileName = "\u65b0\u95fb\u7ad9\u70b9\u7edf\u8ba1\u6570\u636e.xls";
            StringBuffer headNames = new StringBuffer("\u7ad9\u70b9url,\u6d41\u6c34\u53f7,\u5730\u533a,\u5730\u533a\u7f16\u7801,");
            for (String date : spiderReportDto.getDateList()) {
                headNames.append(date);
                headNames.append(",");
            }
            headNames.append("\u603b\u8ba1");
            ExportModel exportModel = this.makeDataReportModel(resultList, headNames.toString(), spiderReportDto.getDateList(), true, false);
            byte[] result = ExportUtils.makeExcel((ExportModel)exportModel, (String)fileName);
            ExportUtils.exportToResponse((HttpServletResponse)response, (String)fileName, (byte[])result, (String)"excel");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u65b0\u95fb\u7ad9\u70b9\u62a5\u8868\u9519\u8bef\uff1a", (Throwable)e);
            return false;
        }
        return true;
    }

    public Page<SpiderReportVo> getWechatNewsAccountReport(SpiderReportDto spiderReportDto) throws Exception {
        Page resultPage = new Page();
        this.dealTime(spiderReportDto);
        PageHelper.startPage((int)spiderReportDto.getPageNum(), (int)spiderReportDto.getPageSize());
        spiderReportDto.setTableList(MultiTableUtils.getWechatNewsTableList());
        List resultList = this.spiderReportMapper.getWechatNewsAccountReport(spiderReportDto);
        Pagination pagination = PageHelper.getPagination();
        resultPage.setCurrent(pagination.getCurrent());
        resultPage.setSize(pagination.getSize());
        resultPage.setTotal(pagination.getTotal());
        this.setResultPageData(resultPage, spiderReportDto.getDateList(), resultList, false, true);
        return resultPage;
    }

    public Boolean exportWechatNewsAccountReport(SpiderReportDto spiderReportDto, HttpServletResponse response) throws Exception {
        this.dealTime(spiderReportDto);
        spiderReportDto.setTableList(MultiTableUtils.getWechatNewsTableList());
        List resultList = this.spiderReportMapper.getWechatNewsAccountReport(spiderReportDto);
        try {
            String fileName = "\u5fae\u4fe1\u65b0\u95fb\u516c\u4f17\u53f7\u7edf\u8ba1\u6570\u636e.xls";
            StringBuffer headNames = new StringBuffer("\u516c\u4f17\u53f7\u540d\u79f0,\u516c\u4f17\u53f7\u8d26\u53f7,\u5730\u533a,\u5730\u533a\u7f16\u7801,");
            for (String date : spiderReportDto.getDateList()) {
                headNames.append(date);
                headNames.append(",");
            }
            headNames.append("\u603b\u8ba1");
            ExportModel exportModel = this.makeDataReportModel(resultList, headNames.toString(), spiderReportDto.getDateList(), false, true);
            byte[] result = ExportUtils.makeExcel((ExportModel)exportModel, (String)fileName);
            ExportUtils.exportToResponse((HttpServletResponse)response, (String)fileName, (byte[])result, (String)"excel");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5fae\u4fe1\u65b0\u95fb\u516c\u4f17\u53f7\u62a5\u8868\u9519\u8bef\uff1a", (Throwable)e);
            return false;
        }
        return true;
    }

    private void dealTime(SpiderReportDto spiderReportDto) throws Exception {
        try {
            if (StringUtils.isNotBlank((String)spiderReportDto.getStartTime())) {
                Date startDate = DateUtils.parseDateTime((String)spiderReportDto.getStartTime());
                Date endDate = StringUtils.isBlank((String)spiderReportDto.getEndTime()) ? new Date() : DateUtils.parseDateTime((String)spiderReportDto.getEndTime());
                endDate = DateUtils.addField((Date)endDate, (int)13, (int)-1);
                spiderReportDto.setStartDate(startDate);
                spiderReportDto.setEndDate(endDate);
                ArrayList<String> dateList = new ArrayList<String>();
                startDate = DateUtils.parseDateTime((String)DateUtils.formatAtWill((Date)startDate, (String)"yyyy-MM-dd 00:00:00"));
                endDate = DateUtils.parseDateTime((String)DateUtils.formatAtWill((Date)endDate, (String)"yyyy-MM-dd 00:00:00"));
                while (startDate.getTime() <= endDate.getTime()) {
                    dateList.add(DateUtils.formatAtWill((Date)startDate, (String)"yyyy-MM-dd"));
                    startDate = DateUtils.addField((Date)startDate, (int)5, (int)1);
                }
                spiderReportDto.setDateList(dateList);
            }
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5fae\u4fe1\u65b0\u95fb\u62a5\u8868\u65f6\u95f4\u53c2\u6570\u9519\u8bef\uff1a", (Throwable)e);
        }
        List dateList = spiderReportDto.getDateList();
        if (CollectionUtils.isEmpty((Collection)dateList) || dateList.size() > 7) {
            throw new Exception("\u67e5\u8be2\u65e5\u671f\u76f8\u5dee\u8d85\u8fc7\u4e03\u5929");
        }
    }

    private void setResultPageData(Page<SpiderReportVo> resultPage, List<String> dateList, List<Map<String, Object>> resultList, boolean containsSite, boolean containsAccount) {
        if (CollectionUtils.isNotEmpty(resultList)) {
            ArrayList<SpiderReportVo> spiderReportVoList = new ArrayList<SpiderReportVo>();
            for (Map<String, Object> result : resultList) {
                SpiderReportVo spiderReportVo = new SpiderReportVo();
                if (containsSite) {
                    spiderReportVo.setSiteUrl(ObjectUtils.toString((Object)result.get("siteUrl")));
                    spiderReportVo.setSerialNum(ObjectUtils.toString((Object)result.get("serialNum")));
                }
                if (containsAccount) {
                    spiderReportVo.setName(ObjectUtils.toString((Object)result.get("name")));
                    spiderReportVo.setAccount(ObjectUtils.toString((Object)result.get("account")));
                }
                spiderReportVo.setRegion(ObjectUtils.toString((Object)result.get("region")));
                if (StringUtils.isBlank((String)ObjectUtils.toString((Object)result.get("regionName")))) {
                    spiderReportVo.setRegionName("\u5168\u56fd");
                } else {
                    spiderReportVo.setRegionName(ObjectUtils.toString((Object)result.get("regionName")));
                }
                spiderReportVo.setTotal(ObjectUtils.toString((Object)result.get("total")));
                spiderReportVo.setFirstDay(ObjectUtils.toString((Object)result.get(dateList.get(0))));
                if (dateList.size() > 1) {
                    spiderReportVo.setSecondDay(ObjectUtils.toString((Object)result.get(dateList.get(1))));
                }
                if (dateList.size() > 2) {
                    spiderReportVo.setThirdDay(ObjectUtils.toString((Object)result.get(dateList.get(2))));
                }
                if (dateList.size() > 3) {
                    spiderReportVo.setFourthDay(ObjectUtils.toString((Object)result.get(dateList.get(3))));
                }
                if (dateList.size() > 4) {
                    spiderReportVo.setFifthDay(ObjectUtils.toString((Object)result.get(dateList.get(4))));
                }
                if (dateList.size() > 5) {
                    spiderReportVo.setSixthDay(ObjectUtils.toString((Object)result.get(dateList.get(5))));
                }
                if (dateList.size() > 6) {
                    spiderReportVo.setSeventhDay(ObjectUtils.toString((Object)result.get(dateList.get(6))));
                }
                spiderReportVo.setDateList(dateList);
                spiderReportVoList.add(spiderReportVo);
            }
            resultPage.setRecords(spiderReportVoList);
        }
    }

    private ExportModel makeDataReportModel(List<Map<String, Object>> resultList, String headNames, List<String> dateList, boolean containsSite, boolean containsAccount) {
        ExportModel exportModel = new ExportModel();
        exportModel.setHeadNames(headNames);
        ArrayList<ExportDataRow> dataRowList = new ArrayList<ExportDataRow>();
        if (CollectionUtils.isNotEmpty(resultList)) {
            for (Map<String, Object> result : resultList) {
                ExportDataRow exportDataRow = new ExportDataRow();
                ArrayList<String> dataColumnList = new ArrayList<String>();
                if (containsSite) {
                    dataColumnList.add(ObjectUtils.toString((Object)result.get("siteUrl")));
                }
                if (containsAccount) {
                    dataColumnList.add(ObjectUtils.toString((Object)result.get("name")));
                    dataColumnList.add(ObjectUtils.toString((Object)result.get("account")));
                }
                if (StringUtils.isBlank((String)ObjectUtils.toString((Object)result.get("regionName")))) {
                    dataColumnList.add("\u5168\u56fd");
                } else {
                    dataColumnList.add(ObjectUtils.toString((Object)result.get("regionName")));
                }
                dataColumnList.add(ObjectUtils.toString((Object)result.get("region")));
                for (String date : dateList) {
                    dataColumnList.add(ObjectUtils.toString((Object)result.get(date)));
                }
                dataColumnList.add(ObjectUtils.toString((Object)result.get("total")));
                exportDataRow.setDataColumnList(dataColumnList);
                dataRowList.add(exportDataRow);
            }
        }
        exportModel.setDataRowList(dataRowList);
        return exportModel;
    }
}

