/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.spider.manager.facade.model.CommodityDetailDTO;
import com.bxm.spider.manager.facade.model.CommodityImageDTO;
import com.bxm.spider.manager.integration.prod.service.ContentDealIntegrationService;
import com.bxm.spider.manager.integration.prod.service.DownloadIntegrationService;
import com.bxm.spider.manager.model.dto.taobao.ApiStack;
import com.bxm.spider.manager.model.dto.taobao.TaobaoJsonDto;
import com.bxm.spider.manager.model.dto.taobao.Value;
import com.bxm.spider.manager.service.config.TaobaoConfig;
import com.bxm.spider.manager.service.service.TaobaoService;
import com.google.common.collect.Lists;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaobaoServiceImpl
implements TaobaoService {
    private static final Logger log = LogManager.getLogger(TaobaoServiceImpl.class);
    @Autowired
    private TaobaoConfig taobaoConfig;
    @Autowired
    private DownloadIntegrationService downloadIntegrationService;
    @Autowired
    private ContentDealIntegrationService contentDealIntegrationService;

    public CommodityDetailDTO info(Long id) {
        CommodityDetailDTO commodityDetailDTO;
        log.info("\u83b7\u53d6\u6dd8\u5b9d\u5546\u54c1\u4fe1\u606f,\u5546\u54c1id:[{}]", (Object)id);
        try {
            String taoBaoInfoUrl = "https://h5api.m.taobao.com/h5/mtop.taobao.detail.getdetail/6.0/?data=" + URLEncoder.encode("{\"itemNumId\":\"" + id + "\"}", "UTF-8");
            TaobaoJsonDto taobaoJsonDto = (TaobaoJsonDto)JSONObject.parseObject((String)this.download(taoBaoInfoUrl), TaobaoJsonDto.class);
            commodityDetailDTO = this.convert(taobaoJsonDto);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4fe1\u606f\u5931\u8d25,error:", (Throwable)e);
            return null;
        }
        return commodityDetailDTO;
    }

    private CommodityDetailDTO convert(TaobaoJsonDto taobaoJsonDto) {
        CommodityDetailDTO commodityDetailDTO = new CommodityDetailDTO();
        commodityDetailDTO.setCommodityId(taobaoJsonDto.getData().getItem().getItemId());
        commodityDetailDTO.setCommodityTitle(taobaoJsonDto.getData().getItem().getTitle());
        commodityDetailDTO.setImgUrlList(taobaoJsonDto.getData().getItem().getImages().stream().map(imgUrl -> StringUtils.join((Object[])new String[]{"https:", imgUrl})).collect(Collectors.toList()));
        Value value = (Value)JSONObject.parseObject((String)((ApiStack)taobaoJsonDto.getData().getApiStack().get(0)).getValue(), Value.class);
        commodityDetailDTO.setSalesNum(value.getItem().getSellCount());
        commodityDetailDTO.setShopName(taobaoJsonDto.getData().getSeller().getShopName());
        commodityDetailDTO.setReservePrice(Double.valueOf(value.getPrice().getPrice().getPriceText().split("-")[0]));
        commodityDetailDTO.setShopIcon(StringUtils.join((Object[])new String[]{"https:", taobaoJsonDto.getData().getSeller().getShopIcon()}));
        commodityDetailDTO.setShopUrl(StringUtils.join((Object[])new String[]{"https:", taobaoJsonDto.getData().getSeller().getTaoShopUrl()}));
        commodityDetailDTO.setShopType(taobaoJsonDto.getData().getSeller().getShopType());
        taobaoJsonDto.getData().getSeller().getEvaluates().forEach(evaluates -> {
            String score = evaluates.getScore().trim();
            switch (evaluates.getType()) {
                case "desc": {
                    commodityDetailDTO.setCommodityScore(score);
                    break;
                }
                case "serv": {
                    commodityDetailDTO.setSellerScore(score);
                    break;
                }
                case "post": {
                    commodityDetailDTO.setLogisticsScore(score);
                    break;
                }
            }
        });
        return commodityDetailDTO;
    }

    private String download(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        log.info("proxy:{}", (Object)this.taobaoConfig.isProxy());
        String page = this.downloadIntegrationService.pageDownload(url, this.taobaoConfig.isProxy());
        return StringUtils.isBlank((CharSequence)page) ? "" : page;
    }

    public List<CommodityImageDTO> detail(Long id) {
        log.info("\u83b7\u53d6\u6dd8\u5b9d\u5546\u54c1\u56fe\u6587\u8be6\u60c5,\u5546\u54c1id:[{}]", (Object)id);
        ArrayList imgs = Lists.newArrayList();
        try {
            String taoBaoDetail = "https://h5api.m.taobao.com/h5/mtop.taobao.detail.getdesc/6.0/?data=" + URLEncoder.encode("{\"id\":\"" + id + "\"}", "UTF-8");
            String content = JSONObject.parseObject((String)this.download(taoBaoDetail)).getJSONObject("data").getString("pcDescContent");
            List imgLabels = this.contentDealIntegrationService.regex(content, "<img.*?src=['|\"](.*?)['|\"].*?>", "0");
            for (String imgLabel : imgLabels) {
                try {
                    CommodityImageDTO commodityImageDTO = new CommodityImageDTO();
                    commodityImageDTO.setUrl(StringUtils.join((Object[])new String[]{"https:", (String)this.contentDealIntegrationService.regex(imgLabel, "<img.*?src=['|\"](.*?)['|\"].*?>", "1").get(0)}));
                    String[] hws = ((String)this.contentDealIntegrationService.regex(imgLabel, "size=\"(.*?)\"", "1").get(0)).split("x");
                    commodityImageDTO.setWidth(hws[0]);
                    commodityImageDTO.setHeight(hws[1]);
                    imgs.add(commodityImageDTO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u5931\u8d25,error:", (Throwable)e);
            return null;
        }
        return imgs;
    }
}

