/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.spider.manager.dal.mapper.UrlRulerMapper;
import com.bxm.spider.manager.model.dao.UrlConfig;
import com.bxm.spider.manager.model.dao.UrlRuler;
import com.bxm.spider.manager.model.dto.UrlRulerDto;
import com.bxm.spider.manager.service.service.UrlConfigService;
import com.bxm.spider.manager.service.service.UrlRulerService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UrlRulerServiceImpl
extends ServiceImpl<UrlRulerMapper, UrlRuler>
implements UrlRulerService {
    @Autowired
    private UrlConfigService urlConfigService;
    @Autowired
    private UrlRulerService urlRulerService;

    public Page<UrlRuler> selectPage(UrlRulerDto urlRulerDto) {
        Page page = new Page();
        page.setCurrent(urlRulerDto.getPageNum().intValue());
        page.setSize(urlRulerDto.getPageSize().intValue());
        EntityWrapper entityWrapper = new EntityWrapper();
        entityWrapper.orderBy("create_time", false);
        if (StringUtils.isNotEmpty((CharSequence)urlRulerDto.getName())) {
            entityWrapper.like("name", urlRulerDto.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)urlRulerDto.getSite())) {
            entityWrapper.like("site", urlRulerDto.getSite());
        }
        if (urlRulerDto.getPageNum() != null) {
            ArrayList resultRuler = Lists.newArrayList();
            String serialNum = urlRulerDto.getSerialNum();
            List list = this.urlConfigService.selectList(new EntityWrapper().eq("serial_num", (Object)serialNum));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList rulerList = Lists.newArrayList();
                for (UrlConfig urlConfig : list) {
                    String rulerSite = urlConfig.getRulerSite();
                    if (rulerList.contains(rulerSite)) continue;
                    rulerList.add(rulerSite);
                }
                List urlRulerList = this.urlRulerService.selectList(new EntityWrapper().in("site", (Collection)rulerList));
                if (CollectionUtils.isNotEmpty((Collection)urlRulerList)) {
                    ArrayList parentSiteList = Lists.newArrayList();
                    for (UrlRuler urlRuler2 : urlRulerList) {
                        String parentSite = urlRuler2.getParentSite();
                        if (parentSite == null || parentSiteList.contains(parentSite)) continue;
                        parentSiteList.add(parentSite);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)parentSiteList)) {
                        List urlRulerParentList = this.urlRulerService.selectList(new EntityWrapper().in("site", (Collection)parentSiteList));
                        resultRuler.addAll(urlRulerParentList);
                    }
                    HashMap siteMap = Maps.newHashMap();
                    urlRulerList.forEach(urlRuler -> siteMap.put(urlRuler.getKeyword(), urlRuler));
                    for (int i = 0; i < resultRuler.size(); ++i) {
                        UrlRuler urlRuler3 = (UrlRuler)resultRuler.get(i);
                        String keyword = urlRuler3.getKeyword();
                        if (!siteMap.containsKey(keyword)) continue;
                        resultRuler.remove(urlRuler3);
                    }
                    resultRuler.addAll(urlRulerList);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)resultRuler)) {
                ArrayList idList = Lists.newArrayList();
                resultRuler.forEach(urlRuler -> idList.add(urlRuler.getId()));
                entityWrapper.in("id", (Collection)idList);
            }
        }
        return super.selectPage(page, (Wrapper)entityWrapper);
    }
}

