/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.manager.service.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.manager.dal.mapper.WeChatAccountMapper;
import com.bxm.spider.manager.facade.dto.AccountQueryDto;
import com.bxm.spider.manager.facade.model.AddAccountDto;
import com.bxm.spider.manager.facade.param.AccountQueryParam;
import com.bxm.spider.manager.integration.prod.service.ContentDealIntegrationService;
import com.bxm.spider.manager.integration.prod.service.DownloadIntegrationService;
import com.bxm.spider.manager.model.dao.WeChatAccount;
import com.bxm.spider.manager.model.dto.AccountExistsDto;
import com.bxm.spider.manager.model.dto.WechatDownloadDto;
import com.bxm.spider.manager.service.config.WechatAccountConfig;
import com.bxm.spider.manager.service.constant.WechatConstant;
import com.bxm.spider.manager.service.service.WeChatAccountService;
import com.bxm.spider.oss.service.AliYunOssService;
import java.io.Serializable;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WeChatAccountServiceImpl
extends ServiceImpl<WeChatAccountMapper, WeChatAccount>
implements WeChatAccountService {
    private static final Logger log = LogManager.getLogger(WeChatAccountServiceImpl.class);
    private final AliYunOssService aliYunOssService;
    private final WechatAccountConfig wechatAccountConfig;
    private final DownloadIntegrationService downloadIntegrationService;
    private final ContentDealIntegrationService contentDealIntegrationService;
    private final RedisClient redisClient;

    @Autowired
    public WeChatAccountServiceImpl(@Qualifier(value="aliYunOssServiceImpl") AliYunOssService aliYunOssService, WechatAccountConfig wechatAccountConfig, DownloadIntegrationService downloadIntegrationService, ContentDealIntegrationService contentDealIntegrationService, RedisClient redisClient) {
        this.aliYunOssService = aliYunOssService;
        this.wechatAccountConfig = wechatAccountConfig;
        this.downloadIntegrationService = downloadIntegrationService;
        this.contentDealIntegrationService = contentDealIntegrationService;
        this.redisClient = redisClient;
    }

    private Message downloadRetry(String url, int retryTime) {
        if (retryTime < 0) {
            return Message.build().setSuccess(Boolean.FALSE.booleanValue()).setMessage("\u5fae\u4fe1\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25\u3002");
        }
        String html = this.downloadIntegrationService.pageDownload(url, Boolean.TRUE.booleanValue());
        if (StringUtils.isNotBlank((CharSequence)html) && html.contains("\u9a8c\u8bc1\u7801")) {
            if (log.isDebugEnabled()) {
                log.debug("\u5305\u542b\u9a8c\u8bc1\u7801\uff0c\u91cd\u8bd5\u6b21\u6570:[{}]", (Object)retryTime);
            }
            return this.downloadRetry(url, --retryTime);
        }
        return Message.build().setSuccess(Boolean.TRUE.booleanValue()).setMessage(html);
    }

    private WechatDownloadDto selectContent(String html) {
        String image = this.selectContent(html, this.wechatAccountConfig.getImageSelect(), "src");
        if (StringUtils.isNotBlank((CharSequence)image)) {
            image = this.aliYunOssService.getOssUrl("http:" + image, "", "");
        }
        String mothId = this.selectContent(html, this.wechatAccountConfig.getMothIdSelect(), "d");
        String account = this.selectContent(html, this.wechatAccountConfig.getAccountSelect());
        String accountName = this.selectContent(html, this.wechatAccountConfig.getAccoutNameSelect());
        if (log.isDebugEnabled()) {
            log.debug("account:[{}],pageName:[{}],mothId:[{}],image:[{}]", (Object)account, (Object)accountName, (Object)mothId, (Object)image);
        }
        return WechatDownloadDto.builder().image(image).mothId(mothId).account(account).accountName(accountName).build();
    }

    private Message paramCheck(AddAccountDto addAccountDto) {
        Message message = Message.build().setSuccess(Boolean.FALSE.booleanValue());
        if (null == addAccountDto) {
            return message.setMessage("\u6dfb\u52a0\u516c\u4f17\u53f7\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)addAccountDto.getAccount())) {
            return message.setMessage("\u516c\u4f17\u53f7\u8f93\u5165\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)addAccountDto.getAreaCode())) {
            return message.setMessage("\u533a\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)addAccountDto.getAreaName())) {
            return message.setMessage("\u533a\u57df\u540d\u79f0\u4e3a\u7a7a");
        }
        return Message.build().setSuccess(Boolean.TRUE.booleanValue());
    }

    @Transactional
    public Message addAccountByName(AddAccountDto addAccountDto) {
        Message message = this.paramCheck(addAccountDto);
        if (!message.isSuccess()) {
            return message;
        }
        message = this.downloadRetry(this.wechatAccountConfig.getAccountSearchUrl() + addAccountDto.getAccount(), 3);
        if (!message.isSuccess()) {
            return message;
        }
        WechatDownloadDto wechat = this.selectContent(message.getLastMessage());
        if (!(!StringUtils.isBlank((CharSequence)wechat.getAccountName()) && wechat.getAccountName().equals(addAccountDto.getAccount()) || !StringUtils.isBlank((CharSequence)wechat.getAccount()) && wechat.getAccount().equals(addAccountDto.getAccount()))) {
            return Message.build().setSuccess(Boolean.FALSE.booleanValue()).setMessage("\u5fae\u4fe1\u516c\u4f17\u53f7\u5728\u641c\u72d7\u5fae\u4fe1\u641c\u7d22\u7ed3\u679c\u4e2d\u672a\u627e\u5230.");
        }
        this.openRegion(addAccountDto.getAreaCode());
        AccountExistsDto accountExistsDto = this.isExists(wechat.getAccount());
        if (!accountExistsDto.getExist().booleanValue()) {
            return this.insert(wechat, addAccountDto);
        }
        if (null != addAccountDto.getForceUpdate() && addAccountDto.getForceUpdate().booleanValue()) {
            return this.forceUpdate(wechat, accountExistsDto.getWeChatAccount(), addAccountDto);
        }
        return Message.build().setSuccess(Boolean.FALSE.booleanValue()).setMessage("\u516c\u4f17\u8d26\u53f7\u5df2\u5b58\u5728");
    }

    public PageWarper<AccountQueryDto> queryAccountByName(AccountQueryParam accountQueryParam) {
        if (null == accountQueryParam) {
            return null;
        }
        Page page = new Page();
        page.setCurrent(accountQueryParam.getPageNum().intValue());
        page.setSize(accountQueryParam.getPageSize().intValue());
        EntityWrapper entityWrapper = new EntityWrapper();
        if (StringUtils.isNotBlank((CharSequence)accountQueryParam.getAccount())) {
            entityWrapper.eq("name", (Object)accountQueryParam.getAccount());
        }
        if (StringUtils.isNotBlank((CharSequence)accountQueryParam.getRegionCode())) {
            entityWrapper.eq("region_code", (Object)accountQueryParam.getRegionCode());
        }
        entityWrapper.eq("status", (Object)1);
        page = this.selectPage(page, (Wrapper)entityWrapper);
        PageWarper pageWarper = new PageWarper();
        pageWarper.setPageNum(page.getCurrent());
        pageWarper.setPageSize(page.getSize());
        pageWarper.setTotal(page.getTotal());
        pageWarper.setHasNextPage(page.hasNext());
        pageWarper.setHasPreviousPage(page.hasPrevious());
        pageWarper.setList(page.getRecords().stream().map(arg_0 -> this.convert(arg_0)).collect(Collectors.toList()));
        return pageWarper;
    }

    private AccountQueryDto convert(WeChatAccount weChatAccount) {
        return AccountQueryDto.builder().id(weChatAccount.getId()).account(weChatAccount.getAccount()).name(weChatAccount.getName()).channel(weChatAccount.getChannel()).regionCode(weChatAccount.getRegionCode()).regionName(weChatAccount.getRegionName()).build();
    }

    private Message insert(WechatDownloadDto wechat, AddAccountDto addAccountDto) {
        this.insert((Object)WeChatAccount.builder().name(wechat.getAccountName()).account(wechat.getAccount()).image(wechat.getImage()).channel(addAccountDto.getChannel()).regionCode(addAccountDto.getAreaCode()).regionName(addAccountDto.getAreaName()).mothId(wechat.getMothId()).mothCount(WechatConstant.DEFAULT_ACCOUNT_MOTH_COUNT).status(WechatConstant.DEFAULT_USABLE_ACCOUNT_STATIS).modifyTime(new Date()).build());
        return Message.build().setSuccess(Boolean.TRUE.booleanValue()).setMessage("\u6dfb\u52a0\u516c\u4f17\u53f7\u6210\u529f");
    }

    private Message forceUpdate(WechatDownloadDto wechat, WeChatAccount dbWechatAccount, AddAccountDto addAccountDto) {
        dbWechatAccount.setName(wechat.getAccountName());
        dbWechatAccount.setAccount(wechat.getAccount());
        dbWechatAccount.setImage(wechat.getImage());
        dbWechatAccount.setChannel(addAccountDto.getChannel());
        dbWechatAccount.setRegionCode(addAccountDto.getAreaCode());
        dbWechatAccount.setRegionName(addAccountDto.getAreaName());
        dbWechatAccount.setMothCount(WechatConstant.DEFAULT_ACCOUNT_MOTH_COUNT);
        dbWechatAccount.setStatus(WechatConstant.DEFAULT_USABLE_ACCOUNT_STATIS);
        dbWechatAccount.setModifyTime(new Date());
        this.updateById((Object)dbWechatAccount);
        return Message.build().setSuccess(Boolean.TRUE.booleanValue()).setMessage("\u5f3a\u5236\u66f4\u65b0\u6210\u529f");
    }

    private String selectContent(String html, String selector, String attr) {
        if (StringUtils.isNotBlank((CharSequence)html) && StringUtils.isNotBlank((CharSequence)selector)) {
            return this.contentDealIntegrationService.select(html, selector, attr);
        }
        return "";
    }

    private String selectContent(String html, String selector) {
        return this.selectContent(html, selector, "");
    }

    private WeChatAccount getByAccount(String account) {
        EntityWrapper wrapper = new EntityWrapper();
        wrapper.eq("account", (Object)account);
        wrapper.eq("status", (Object)1);
        return (WeChatAccount)this.selectOne((Wrapper)wrapper);
    }

    public AccountExistsDto isExists(String account) {
        WeChatAccount weChatAccount;
        AccountExistsDto accountExistsDto = new AccountExistsDto();
        accountExistsDto.setExist(Boolean.FALSE);
        if (StringUtils.isNotBlank((CharSequence)account) && null != (weChatAccount = this.getByAccount(account))) {
            accountExistsDto.setWeChatAccount(weChatAccount);
            accountExistsDto.setExist(Boolean.TRUE);
        }
        return accountExistsDto;
    }

    public void openRegion(String regionCode) {
        if (!this.redisClient.sismember("SET:WECHAT:ACCOUNT", regionCode)) {
            this.redisClient.sadd("SET:WECHAT:ACCOUNT", new String[]{regionCode});
        }
    }

    public Boolean delete(Long id) {
        return this.deleteById((Serializable)id);
    }
}

