package com.bxm.spider.prod.integration.download.impl;

import com.bxm.spider.constant.exception.BaseRunException;
import com.bxm.spider.constant.monitor.*;
import com.bxm.spider.constant.task.TaskConstant;
import com.bxm.spider.download.facade.service.DownloadFeignService;
import com.bxm.spider.prod.integration.download.DownLoadIntegrationService;
import com.bxm.spider.prod.integration.download.model.DownLoadDto;
import com.bxm.spider.response.ResponseModel;
import com.bxm.spider.response.ResponseModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 下载服务调用实现
 *
 * @ClassName SpiderDownLoadIntegrationServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/22 15:58
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/22 15:58
 **/
@Service
public class DownLoadIntegrationServiceImpl implements DownLoadIntegrationService {

    private Logger logger = LoggerFactory.getLogger(DownLoadIntegrationServiceImpl.class);

    @Autowired
    private DownloadFeignService downloadFeignService;

    @Override
    public Boolean httpDownLoad(DownLoadDto downLoadDto) {
        ResponseModel<Boolean> responseModel = ResponseModelFactory.FAILED();
        try {
            responseModel = downloadFeignService.download(downLoadDto);
            if(logger.isDebugEnabled()){
                logger.debug("execute download success params:{}", downLoadDto);
            }
            // 参数错误
            if(responseModel.isError()){
                throw new BaseRunException(responseModel.getMessage());
            }
        } catch (Exception e) {
            // 请求失败自动重试
            for (int i = 0; i < TaskConstant.RETRY_TIME; i++) {
                try {
                    logger.warn("调用下载中心失败正在重试！data: {}, message: {}", downLoadDto, e.getMessage());
                    responseModel = downloadFeignService.download(downLoadDto);
                    if (responseModel.isSuccess()) {
                        break;
                    }
                } catch (Exception e1) {
                    logger.warn("重试失败{}次！data: {}, message: {}",i + 1 ,downLoadDto, e.getMessage());
                }
            }
            if(responseModel.isError()){
                logger.error(MonitorConstant.MONITOR, "调用下载中心失败！downLoadDto: {} {}", downLoadDto, MonitorHelper.ofFailLog(
                        MonitorConstant.PROD_PROGRESS, downLoadDto.getProcessorParameter(), ErrorEnum.PROD_DOWNLOAD_ERROR, e.getMessage()), e);
                return false;
            }
        }
        return true;
    }

    @Override
    public Boolean httpDownLoadImage(DownLoadDto downLoadDto) {
        ResponseModel<Boolean> responseModel = ResponseModelFactory.FAILED();
        try {
            responseModel = downloadFeignService.download(downLoadDto);
            if(logger.isDebugEnabled()){
                logger.debug("execute download success params:{}", downLoadDto);
            }
            // 参数错误
            if(responseModel.isError()){
                throw new BaseRunException(responseModel.getMessage());
            }
        } catch (Exception e) {
            // 请求失败自动重试
            for (int i = 0; i < TaskConstant.RETRY_TIME; i++) {
                try {
                    logger.warn("调用下载中心图片下载失败正在重试！data: {}, message: {}", downLoadDto, e.getMessage());
                    responseModel = downloadFeignService.download(downLoadDto);
                    if (responseModel.isSuccess()) {
                        break;
                    }
                } catch (Exception e1) {
                    logger.warn("重试失败{}次！data: {}, message: {}",i + 1 ,downLoadDto, e.getMessage());
                }
            }
            if(responseModel.isError()){
                logger.error("调用下载中心失败！{}",downLoadDto, e);
                return false;
            }
        }
        return true;
    }
}
