/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.integration.service.impl;

import com.bxm.spider.constant.monitor.ErrorEnum;
import com.bxm.spider.constant.monitor.MonitorConstant;
import com.bxm.spider.constant.monitor.MonitorHelper;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.prod.facade.DownloadFeignService;
import com.bxm.spider.prod.integration.service.DownLoadIntegrationService;
import com.bxm.spider.prod.param.DownloadParam;
import com.bxm.spider.response.ResponseModel;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DownLoadIntegrationServiceImpl
implements DownLoadIntegrationService {
    private static final org.apache.logging.log4j.Logger log = LogManager.getLogger(DownLoadIntegrationServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(DownLoadIntegrationServiceImpl.class);
    private final DownloadFeignService downloadFeignService;

    @Autowired
    public DownLoadIntegrationServiceImpl(DownloadFeignService downloadFeignService) {
        this.downloadFeignService = downloadFeignService;
    }

    @Override
    public Boolean httpDownLoad(DownloadParam downLoadParam) {
        ResponseModel<Boolean> responseModel = this.downloadFeignService.download(downLoadParam);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("execute download success params:{}", (Object)downLoadParam);
        }
        if (null != responseModel && responseModel.isError()) {
            this.logger.error(MonitorConstant.MONITOR, "\u8c03\u7528\u4e0b\u8f7d\u4e2d\u5fc3\u5931\u8d25\uff01downLoadDto: {} {}", (Object)downLoadParam, (Object)MonitorHelper.ofFailLog((String)"PROD_PROGRESS", (ProcessorParameter)downLoadParam.getProcessorParameter(), (ErrorEnum)ErrorEnum.PROD_DOWNLOAD_ERROR, (String)""));
            return false;
        }
        return true;
    }

    @Override
    public Boolean httpDownLoadImage(DownloadParam downLoadParam) {
        ResponseModel<Boolean> responseModel = this.downloadFeignService.download(downLoadParam);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("execute download success params:{}", (Object)downLoadParam);
        }
        if (null != responseModel && responseModel.isError()) {
            this.logger.error("\u8c03\u7528\u4e0b\u8f7d\u4e2d\u5fc3\u5931\u8d25\uff01{}", (Object)downLoadParam);
            return false;
        }
        return true;
    }
}

