package com.bxm.spider.prod.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 前端配置表
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-18
 */
@TableName("url_config")
public class UrlConfig implements Serializable {

    private static final long serialVersionUID = 2462130480365277440L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 任务流水号
     */
    private String serialNum;
    /**
     * 目标url
     */
    private String url;
    /**
     * 是否使用代理 0-否 1-是，默认值0
     */
    private Integer proxyFlag;
    /**
     * 网页cookie
     */
    private String cookie;
    /**
     * 站点类型:1全国内容,2地方内容,3地方测试新闻,4优惠券;21地方招聘,22地方新闻;221地方公众号,222地方网站,223地方app
     */
    private String siteType;
    /**
     * 网页UserAgent
     */
    private String userAgent;
    /**
     * 请求 referer 参数
     */
    private String referer;
    /**
     * 频道
     */
    private String channel;
    /**
     * 处理器类型 HTML KUAIYINSHI WECHAT
     */
    private String processorType;
    /**
     * 存储器类型:NEWS-新闻,WECHAT-公众号,VIDEO-小视频,RECRUIT-招聘
     */
    private String persistenceType;
    /**
     * 指定编码
     */
    private String charset;
    /**
     * 下载预处理类型
     */
    private String pretreatmentType;
    /**
     * 下载预处理参数
     */
    private String pretreatmentParam;
    /**
     * url频道分类描述
     */
    private String channelDesc;
    /**
     * 地区
     */
    private String region;
    /**
     * 过滤规则site
     */
    private String rulerSite;
    /**
     * 状态(0-不可用 1-可用)
     */
    private Integer status;
    /**
     * 列表爬取深度
     */
    private Integer queueDepth;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人
     */
    private String createUser;
    /**
     * 修改时间
     */
    private Date modifyTime;
    /**
     * 修改人
     */
    private String modifyUser;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSerialNum() {
        return serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getProxyFlag() {
        return proxyFlag;
    }

    public void setProxyFlag(Integer proxyFlag) {
        this.proxyFlag = proxyFlag;
    }

    public String getCookie() {
        return cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public String getSiteType() {
        return siteType;
    }

    public void setSiteType(String siteType) {
        this.siteType = siteType;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getReferer() {
        return referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getProcessorType() {
        return processorType;
    }

    public void setProcessorType(String processorType) {
        this.processorType = processorType;
    }

    public String getPersistenceType() {
        return persistenceType;
    }

    public void setPersistenceType(String persistenceType) {
        this.persistenceType = persistenceType;
    }

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getPretreatmentType() {
        return pretreatmentType;
    }

    public void setPretreatmentType(String pretreatmentType) {
        this.pretreatmentType = pretreatmentType;
    }

    public String getPretreatmentParam() {
        return pretreatmentParam;
    }

    public void setPretreatmentParam(String pretreatmentParam) {
        this.pretreatmentParam = pretreatmentParam;
    }

    public String getChannelDesc() {
        return channelDesc;
    }

    public void setChannelDesc(String channelDesc) {
        this.channelDesc = channelDesc;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRulerSite() {
        return rulerSite;
    }

    public void setRulerSite(String rulerSite) {
        this.rulerSite = rulerSite;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getQueueDepth() {
        return queueDepth;
    }

    public void setQueueDepth(Integer queueDepth) {
        this.queueDepth = queueDepth;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }
}
