/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.service.controller;

import com.bxm.spider.prod.facade.model.dto.TaskDto;
import com.bxm.spider.prod.facade.model.dto.TaskUrlDto;
import com.bxm.spider.prod.facade.service.TaskFeignService;
import com.bxm.spider.prod.service.service.JobService;
import com.bxm.spider.prod.service.service.UrlDealService;
import com.bxm.spider.response.ResponseModel;
import com.bxm.spider.response.ResponseModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/task"})
public class SpiderController
implements TaskFeignService {
    @Autowired
    private JobService jobService;
    @Autowired
    private UrlDealService urlDealService;

    @RequestMapping(value={"/start"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> start(@RequestBody TaskDto taskDto) {
        return ResponseModelFactory.SUCCESS((Object)this.jobService.addCronJob(taskDto.getSerialNum()));
    }

    @RequestMapping(value={"/pause"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> pause(@RequestBody TaskDto taskDto) {
        return ResponseModelFactory.SUCCESS((Object)this.jobService.pauseJob(taskDto.getSerialNum()));
    }

    @RequestMapping(value={"/resume"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> resume(@RequestBody TaskDto taskDto) {
        return ResponseModelFactory.SUCCESS((Object)this.jobService.resumeJob(taskDto.getSerialNum()));
    }

    @RequestMapping(value={"/stop"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> stop(@RequestBody TaskDto taskDto) {
        return ResponseModelFactory.SUCCESS((Object)this.jobService.deleteJob(taskDto.getSerialNum()));
    }

    @RequestMapping(value={"/restartAll"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> restartAll() {
        return ResponseModelFactory.SUCCESS((Object)this.jobService.restartAllJob());
    }

    @RequestMapping(value={"/pushDetailsList"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> pushDetailsList(@RequestBody TaskUrlDto taskUrlDto) {
        return ResponseModelFactory.SUCCESS((Object)this.urlDealService.pushDetailsList(taskUrlDto));
    }

    @RequestMapping(value={"/pushQueueList"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> pushQueueList(@RequestBody TaskUrlDto taskUrlDto) {
        return ResponseModelFactory.SUCCESS((Object)this.urlDealService.pushQueueList(taskUrlDto));
    }

    @RequestMapping(value={"/pushImageList"}, method={RequestMethod.POST})
    public ResponseModel<Boolean> pushImageList(@RequestBody TaskUrlDto taskUrlDto) {
        return ResponseModelFactory.SUCCESS((Object)this.urlDealService.pushImageList(taskUrlDto));
    }
}

