/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.service.job;

import com.bxm.spider.utils.NamedThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JobThreadPool {
    private Logger logger = LoggerFactory.getLogger(JobThreadPool.class);
    private ThreadPoolExecutor pool;
    private ScheduledExecutorService scheduled;
    private LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();

    public JobThreadPool() {
        this.pool = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("jobPool"));
        this.scheduled = new ScheduledThreadPoolExecutor(3, (ThreadFactory)new NamedThreadFactory("scheduledJobPool"));
        for (int i = 0; i < 3; ++i) {
            this.scheduled.scheduleAtFixedRate(() -> {
                try {
                    this.logger.info("\u5f53\u524d\u4ee3\u7406\u961f\u5217\u957f\u5ea6:[{}]", (Object)this.queue.size());
                    Runnable take = (Runnable)this.queue.take();
                    take.run();
                }
                catch (InterruptedException e) {
                    this.logger.error("\u5b9a\u65f6job\u6267\u884c\u9519\u8bef\uff01", (Throwable)e);
                }
            }, 5000L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void execute(Runnable runnable) {
        this.pool.execute(runnable);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.pool.submit(task);
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    public void executeScheduled(Runnable runnable) {
        try {
            this.queue.put(runnable);
        }
        catch (InterruptedException e) {
            this.logger.error("\u6dfb\u52a0\u4efb\u52a1\u5931\u8d25!", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger(JobThreadPool.class);
        JobThreadPool JobThreadPool2 = new JobThreadPool();
        for (int i = 0; i < 10; ++i) {
            JobThreadPool2.executeScheduled(() -> logger.info(" \u6267\u884c\u4efb\u52a1"));
        }
    }
}

