/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.job;

import com.alibaba.fastjson.JSONObject;
import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.cache.constant.TaskKeyConstant;
import com.bxm.spider.constant.monitor.ErrorEnum;
import com.bxm.spider.constant.monitor.MonitorConstant;
import com.bxm.spider.constant.monitor.MonitorHelper;
import com.bxm.spider.constant.processor.PretreatmentEnum;
import com.bxm.spider.constant.proxy.ProxyFlagEnum;
import com.bxm.spider.constant.url.UrlTypeEnum;
import com.bxm.spider.prod.common.constants.Constant;
import com.bxm.spider.prod.integration.service.DownLoadIntegrationService;
import com.bxm.spider.prod.job.JobThreadPool;
import com.bxm.spider.prod.job.ProdJob;
import com.bxm.spider.prod.model.dao.UrlConfig;
import com.bxm.spider.prod.param.DownloadParam;
import com.bxm.spider.prod.utils.ProdServiceUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SpiderDetailsJob
extends ProdJob {
    private Logger logger = LoggerFactory.getLogger(SpiderDetailsJob.class);
    private final Integer DEFAULT_EXECUTE_RATE = 1;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private DownLoadIntegrationService downLoadIntegrationService;
    @Autowired
    private JobThreadPool jobThreadPool;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        String serialNum = data.getString(Constant.SERIAL_NUM);
        try {
            String detailKey = TaskKeyConstant.getDetailList((String)serialNum);
            Integer executeRate = this.DEFAULT_EXECUTE_RATE;
            try {
                executeRate = data.getInt(Constant.EXECUTE_RATE);
            }
            catch (Exception e) {
                this.logger.error("SpiderRateJob\u83b7\u53d6\u6267\u884c\u9891\u7387\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c {}, \u6d41\u6c34\u53f7\uff1a{}", new Object[]{this.DEFAULT_EXECUTE_RATE, executeRate, e});
            }
            for (int i = 0; i < executeRate; ++i) {
                String detailsUrl = this.redisClient.lpop(detailKey);
                if (StringUtils.isEmpty((CharSequence)detailsUrl)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("details job:{}, pop url: null", (Object)context.getJobDetail().getKey());
                    continue;
                }
                this.logger.info(MonitorConstant.MONITOR, MonitorHelper.ofSuccessLog((String)"PROD_START", (String)serialNum, (UrlTypeEnum)UrlTypeEnum.URL_DETAIL));
                String[] urls = detailsUrl.split(Constant.URL_JOINT_CHAR);
                if (urls.length != 2) {
                    this.logger.warn("\u51fa\u73b0\u975e\u6cd5\u8bf7\u6c42url: {}", (Object)detailsUrl);
                    continue;
                }
                UrlConfig urlConfig = (UrlConfig)data.get((Object)urls[0]);
                detailsUrl = urls[1];
                if (urlConfig == null) {
                    this.logger.warn("urlconfig \u4e0d\u5b58\u5728\uff01\u51fa\u73b0\u975e\u6cd5\u8bf7\u6c42url: {}", (Object)detailsUrl);
                    continue;
                }
                String requestUrl = detailsUrl;
                Integer proxyFlag = urlConfig.getProxyFlag();
                if (ProxyFlagEnum.PROXY_OPEN.getCode().equals(proxyFlag)) {
                    this.jobThreadPool.executeScheduled(() -> this.executeDown(urlConfig, context, requestUrl, detailKey));
                    continue;
                }
                this.jobThreadPool.execute(() -> this.executeDown(urlConfig, context, requestUrl, detailKey));
            }
        }
        catch (Exception e) {
            this.logger.error(MonitorConstant.MONITOR, "\u3010\u6267\u884c\u961f\u5217\u4e0b\u8f7d\u51fa\u9519\u3011{} exception:", (Object)MonitorHelper.ofFailLog((String)"PROD_PROGRESS", (String)serialNum, (UrlTypeEnum)UrlTypeEnum.URL_DETAIL, (ErrorEnum)ErrorEnum.PROD_ERROR, (String)e.getMessage()), (Object)e);
        }
    }

    private void executeDown(UrlConfig urlConfig, JobExecutionContext context, String detailsUrl, String detailKey) {
        String serialNum = urlConfig.getSerialNum();
        if (StringUtils.isEmpty((CharSequence)this.redisClient.hGet(TaskKeyConstant.getTaskExecutingHash(), serialNum)) && this.logger.isDebugEnabled()) {
            this.logger.debug("\u4efb\u52a1\u5df2\u505c\u6b62\uff0c\u4e0d\u6267\u884c\u8be6\u60c5\u8c03\u5ea6\u64cd\u4f5c\uff01serialNum: {}", (Object)serialNum);
            return;
        }
        String jsonStr = this.redisClient.hgetAnddel(TaskKeyConstant.getUrlObjectHash((String)serialNum), detailsUrl);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String cookie = urlConfig.getCookie();
        String userAgent = urlConfig.getUserAgent();
        String referer = urlConfig.getReferer();
        String channel = urlConfig.getChannel();
        String originUrl = urlConfig.getUrl();
        String charset = urlConfig.getCharset();
        String pretreatmentParam = urlConfig.getPretreatmentParam();
        PretreatmentEnum pretreatmentType = StringUtils.isBlank((CharSequence)urlConfig.getPretreatmentType()) ? null : PretreatmentEnum.valueOf((String)urlConfig.getPretreatmentType());
        String processorType = null == jsonObject || null == jsonObject.get((Object)"processor") || "".equals(String.valueOf(jsonObject.get((Object)"processor"))) ? urlConfig.getProcessorType() : jsonObject.get((Object)"processor") + "";
        String persistenceType = null == jsonObject || null == jsonObject.get((Object)"persistence") || "".equals(String.valueOf(jsonObject.get((Object)"persistence"))) ? urlConfig.getPersistenceType() : jsonObject.get((Object)"persistence") + "";
        String urlType = null == jsonObject || null == jsonObject.get((Object)"url_type") || "".equals(String.valueOf(jsonObject.get((Object)"url_type"))) ? UrlTypeEnum.URL_DETAIL.getValue() : jsonObject.get((Object)"url_type") + "";
        ProxyFlagEnum proxyFlag = ProxyFlagEnum.PROXY_OPEN.getCode().intValue() == urlConfig.getProxyFlag().intValue() ? ProxyFlagEnum.PROXY_OPEN : ProxyFlagEnum.PROXY_CLOSE;
        List loginAccountList = this.getLoginAccountParamList(context);
        this.jobThreadPool.execute(() -> {
            DownloadParam downLoadParam = ProdServiceUtils.ofDownloadDto((String)detailsUrl, (String)originUrl, (String)cookie, (String)userAgent, (String)referer, (String)channel, (String)serialNum, (String)urlType, (String)processorType, (String)charset, (String)pretreatmentParam, (PretreatmentEnum)pretreatmentType, (ProxyFlagEnum)proxyFlag, (String)persistenceType, (String)(null == jsonObject ? "" : jsonObject.getString("json_object")), (List)loginAccountList);
            Boolean success = this.downLoadIntegrationService.httpDownLoad(downLoadParam);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("execute job: {}, download params:{}", (Object)context.getJobDetail().getKey(), (Object)downLoadParam);
            }
            if (success.booleanValue()) {
                this.redisClient.sadd(TaskKeyConstant.getCatchSet((String)serialNum), new String[]{detailsUrl});
                this.logger.info("execute details url success! serialNum: {}, redis key: {}, url: {}", new Object[]{serialNum, detailKey, detailsUrl});
            } else {
                this.logger.error("execute details url: {} error ,serialNum: {}, push to the end of the list, redis key: {}", new Object[]{detailsUrl, serialNum, detailKey});
                this.redisClient.lpush(detailKey, detailsUrl);
            }
            this.logger.info(MonitorConstant.MONITOR, MonitorHelper.ofSuccessLog((String)"PROD_END", (String)serialNum, (UrlTypeEnum)UrlTypeEnum.URL_DETAIL));
        });
    }
}

