/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.job;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.cache.constant.TaskKeyConstant;
import com.bxm.spider.prod.common.constants.ConfigStatusEnum;
import com.bxm.spider.prod.common.constants.Constant;
import com.bxm.spider.prod.job.ProdJob;
import com.bxm.spider.prod.model.dao.UrlConfig;
import com.bxm.spider.prod.service.UrlConfigService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SpiderJob
extends ProdJob {
    private Logger logger = LoggerFactory.getLogger(SpiderJob.class);
    @Autowired
    private UrlConfigService urlConfigService;
    @Autowired
    private RedisClient redisClient;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        String serialNum = jobDataMap.getString(Constant.SERIAL_NUM);
        this.redisClient.del(TaskKeyConstant.getDepthCatchHash((String)serialNum));
        this.redisClient.del(TaskKeyConstant.getQueueCatchSet((String)serialNum));
        if (StringUtils.isEmpty((CharSequence)this.redisClient.hGet(TaskKeyConstant.getTaskExecutingHash(), serialNum))) {
            this.redisClient.hSet(TaskKeyConstant.getTaskExecutingHash(), serialNum, "EXECUTING");
        }
        List urlConfigList = this.urlConfigService.selectList(new EntityWrapper().eq("serial_num", (Object)serialNum).eq("status", (Object)ConfigStatusEnum.USABLE.getCode()));
        for (UrlConfig urlConfig : urlConfigList) {
            String queueUrl = urlConfig.getUrl();
            this.redisClient.rpush(TaskKeyConstant.getQueueList((String)serialNum), queueUrl);
            this.logger.info("execute job: {}, add field {} to redis key {} success!", new Object[]{jobExecutionContext.getJobDetail().getKey(), queueUrl, TaskKeyConstant.getQueueList((String)serialNum)});
        }
    }
}

