/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.cache.constant.TaskKeyConstant;
import com.bxm.spider.constant.processor.PretreatmentEnum;
import com.bxm.spider.constant.processor.ProcessorEnum;
import com.bxm.spider.constant.proxy.ProxyFlagEnum;
import com.bxm.spider.constant.url.UrlTypeEnum;
import com.bxm.spider.prod.common.constants.Constant;
import com.bxm.spider.prod.integration.service.DownLoadIntegrationService;
import com.bxm.spider.prod.model.dao.UrlConfig;
import com.bxm.spider.prod.model.param.TaskUrlParam;
import com.bxm.spider.prod.param.DownloadParam;
import com.bxm.spider.prod.service.UrlConfigService;
import com.bxm.spider.prod.service.UrlDealService;
import com.bxm.spider.prod.utils.ProdServiceUtils;
import com.bxm.spider.utils.NamedThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UrlDealServiceImpl
implements UrlDealService {
    private Logger logger = LoggerFactory.getLogger(UrlDealServiceImpl.class);
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private UrlConfigService urlConfigService;
    @Autowired
    private DownLoadIntegrationService downLoadIntegrationService;
    private final ExecutorService executorService = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("urlDealServiceImpl"));

    public boolean pushDetailsList(TaskUrlParam taskUrlParam) {
        boolean isCommentUrl;
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)taskUrlParam.getJsonObject())) {
            jsonObject.put("json_object", (Object)taskUrlParam.getJsonObject());
        }
        if (null != taskUrlParam.getPersistenceEnum() && StringUtils.isNotBlank((CharSequence)taskUrlParam.getPersistenceEnum().getName())) {
            jsonObject.put("persistence", (Object)taskUrlParam.getPersistenceEnum().getName());
        }
        if (null != taskUrlParam.getProcessorEnum() && StringUtils.isNotBlank((CharSequence)taskUrlParam.getProcessorEnum().name())) {
            jsonObject.put("processor", (Object)taskUrlParam.getProcessorEnum().name());
        }
        boolean bl = isCommentUrl = null != taskUrlParam.getType() && StringUtils.isNotBlank((CharSequence)taskUrlParam.getType().getValue()) && taskUrlParam.getType().equals((Object)UrlTypeEnum.URL_COMMENT);
        if (isCommentUrl) {
            jsonObject.put("url_type", (Object)UrlTypeEnum.URL_COMMENT);
        }
        String serialNum = taskUrlParam.getSerialNum();
        String originUrl = taskUrlParam.getOriginUrl();
        String detailsKey = TaskKeyConstant.getDetailList((String)serialNum);
        List detailsUrlList = JSONArray.parseArray((String)taskUrlParam.getUrlList(), String.class);
        for (String url : detailsUrlList) {
            boolean isMember = this.redisClient.sismember(TaskKeyConstant.getCatchSet((String)serialNum), url);
            if (!taskUrlParam.getForcedDownload().booleanValue() && isMember) continue;
            this.redisClient.rpush(detailsKey, ProdServiceUtils.getSaveUrl((String)originUrl, (String)url));
            this.redisClient.hSet(TaskKeyConstant.getUrlObjectHash((String)serialNum), url, jsonObject.toJSONString());
        }
        return true;
    }

    public boolean pushQueueList(TaskUrlParam taskUrlParam) {
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)taskUrlParam.getJsonObject())) {
            jsonObject.put("json_object", (Object)taskUrlParam.getJsonObject());
        }
        if (null != taskUrlParam.getPersistenceEnum() && StringUtils.isNotBlank((CharSequence)taskUrlParam.getPersistenceEnum().getName())) {
            jsonObject.put("persistence", (Object)taskUrlParam.getPersistenceEnum().getName());
        }
        if (null != taskUrlParam.getProcessorEnum() && StringUtils.isNotBlank((CharSequence)taskUrlParam.getProcessorEnum().name())) {
            jsonObject.put("processor", (Object)taskUrlParam.getProcessorEnum().name());
        }
        String serialNum = taskUrlParam.getSerialNum();
        String originUrl = taskUrlParam.getOriginUrl();
        UrlConfig urlConfig = (UrlConfig)this.urlConfigService.selectOne(new EntityWrapper().eq("serial_num", (Object)serialNum).eq("url", (Object)originUrl));
        if (urlConfig == null) {
            this.logger.warn("\u3010\u63a8\u9001\u5217\u8868\u961f\u5217\u6570\u636e\u5f02\u5e38\u3011\u5217\u8868url urlConfig \u4e0d\u5b58\u5728,taskUrlDto:{}", (Object)taskUrlParam);
            return false;
        }
        Integer depth = urlConfig.getQueueDepth() == null ? Constant.DEFAULT_DEPTH : urlConfig.getQueueDepth();
        String queueKey = TaskKeyConstant.getQueueList((String)serialNum);
        List queueUrlList = JSONArray.parseArray((String)taskUrlParam.getUrlList(), String.class);
        for (String url : queueUrlList) {
            String times = this.redisClient.hGet(TaskKeyConstant.getDepthCatchHash((String)serialNum), originUrl);
            if (times != null && Integer.valueOf(times) >= depth) continue;
            boolean isMember = this.redisClient.sismember(TaskKeyConstant.getQueueCatchSet((String)serialNum), url);
            if (!taskUrlParam.getForcedDownload().booleanValue() && isMember) continue;
            this.redisClient.hincrByOne(TaskKeyConstant.getDepthCatchHash((String)serialNum), originUrl);
            if (BooleanUtils.isTrue((Boolean)taskUrlParam.getProdFirst())) {
                this.redisClient.lpush(queueKey, ProdServiceUtils.getSaveUrl((String)originUrl, (String)url));
            } else {
                this.redisClient.rpush(queueKey, ProdServiceUtils.getSaveUrl((String)originUrl, (String)url));
            }
            this.redisClient.hSet(TaskKeyConstant.getUrlObjectHash((String)serialNum), url, jsonObject.toJSONString());
        }
        return true;
    }

    public boolean pushImageList(TaskUrlParam taskUrlParam) {
        if (null == taskUrlParam) {
            this.logger.error("image url is null!");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)taskUrlParam.getUrlList()) || StringUtils.isBlank((CharSequence)taskUrlParam.getSerialNum()) || StringUtils.isBlank((CharSequence)taskUrlParam.getOriginUrl())) {
            this.logger.error("image url is empty or serialNum is empty or origin url is empty!");
            return false;
        }
        String serialNum = taskUrlParam.getSerialNum();
        String originUrl = taskUrlParam.getOriginUrl();
        UrlConfig urlConfig = (UrlConfig)this.urlConfigService.selectOne(new EntityWrapper().eq("serial_num", (Object)serialNum).eq("url", (Object)originUrl));
        if (urlConfig == null) {
            this.logger.warn("\u6570\u636e\u5f02\u5e38\uff01\u56fe\u7247url urlConfig \u4e0d\u5b58\u5728,taskUrlDto:{}", (Object)taskUrlParam);
            return false;
        }
        String cookie = urlConfig.getCookie();
        String userAgent = urlConfig.getUserAgent();
        String referer = urlConfig.getReferer();
        String channel = urlConfig.getChannel();
        String charset = urlConfig.getCharset();
        String pretreatmentParam = urlConfig.getPretreatmentParam();
        PretreatmentEnum pretreatmentType = StringUtils.isBlank((CharSequence)urlConfig.getPretreatmentType()) ? null : PretreatmentEnum.valueOf((String)urlConfig.getPretreatmentType());
        String processorType = ProcessorEnum.IMAGE.name();
        String persistenceType = null == taskUrlParam.getPersistenceEnum() ? urlConfig.getPersistenceType() : taskUrlParam.getPersistenceEnum().getName();
        String object = taskUrlParam.getJsonObject();
        String imageKey = TaskKeyConstant.getImageCatchSet((String)serialNum);
        List imageUrlList = JSONArray.parseArray((String)taskUrlParam.getUrlList(), String.class);
        for (String url : imageUrlList) {
            this.executorService.execute(() -> {
                if (StringUtils.isBlank((CharSequence)url)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("the url is null,origin url is {},serialNum is {} ", (Object)originUrl, (Object)serialNum);
                    }
                    return;
                }
                boolean isMember = this.redisClient.sismember(imageKey, url);
                if (isMember && !taskUrlParam.getForcedDownload().booleanValue()) {
                    return;
                }
                DownloadParam downLoadParam = ProdServiceUtils.ofDownloadDto((String)url, (String)originUrl, (String)cookie, (String)userAgent, (String)referer, (String)channel, (String)serialNum, (String)UrlTypeEnum.URL_DETAIL.getValue(), (String)processorType, (String)charset, (String)pretreatmentParam, (PretreatmentEnum)pretreatmentType, (ProxyFlagEnum)ProxyFlagEnum.PROXY_CLOSE, (String)persistenceType, (String)object, new ArrayList());
                Boolean success = this.downLoadIntegrationService.httpDownLoadImage(downLoadParam);
                if (success.booleanValue()) {
                    this.redisClient.sadd(imageKey, new String[]{url});
                    this.logger.info("execute image url success! serialNum: {}, redis key: {}, url: {}", new Object[]{serialNum, imageKey, url});
                } else {
                    this.logger.error("execute details url: {} error ,serialNum: {}, push to the end of the list, redis key: {}", new Object[]{url, serialNum, imageKey});
                }
                this.logger.info("\u3010\u56fe\u7247\u8c03\u5ea6\u7ed3\u675f\u3011url:{},\u5b58\u50a8\u5668:{}", (Object)url, (Object)downLoadParam.getProcessorParameter().getPersistenceEnum().getName());
            });
        }
        return true;
    }
}

