/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.prod.utils;

import com.bxm.spider.constant.processor.PersistenceEnum;
import com.bxm.spider.constant.processor.PretreatmentEnum;
import com.bxm.spider.constant.processor.ProcessorEnum;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.constant.proxy.ProxyFlagEnum;
import com.bxm.spider.constant.url.UrlTypeEnum;
import com.bxm.spider.prod.common.constants.Constant;
import com.bxm.spider.prod.job.SpiderQueueJob;
import com.bxm.spider.prod.param.DownloadParam;
import com.bxm.spider.prod.param.LoginAccountParam;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProdServiceUtils {
    private static Logger logger = LoggerFactory.getLogger(SpiderQueueJob.class);

    public static String getDetailsJobName(String serialNum) {
        return StringUtils.join((Object[])new String[]{Constant.JOB_DETAILS_HEAD, serialNum}, (String)"_");
    }

    public static String getQueueJobName(String serialNum) {
        return StringUtils.join((Object[])new String[]{Constant.JOB_QUEUE_HEAD, serialNum}, (String)"_");
    }

    public static String getJobName(String serialNum) {
        return StringUtils.join((Object[])new String[]{Constant.JOB_HEAD, serialNum}, (String)"_");
    }

    public static String getJobGroupName(String taskName) {
        return StringUtils.join((Object[])new String[]{Constant.JOB_GROUP_HEAD, taskName}, (String)"_");
    }

    public static DownloadParam ofDownloadDto(String url, String originUrl, String cookie, String userAgent, String referer, String channel, String serialNum, String urlTypeEnum, String processorEnumName, String charset, String pretreatmentParam, PretreatmentEnum pretreatmentEnum, ProxyFlagEnum proxyFlag, String persistenceType, String object, List<LoginAccountParam> LoginAccountParamList) {
        try {
            DownloadParam downLoadParam = new DownloadParam();
            ProcessorParameter processorParameter = new ProcessorParameter();
            processorParameter.setSerialNum(serialNum);
            processorParameter.setUrl(StringUtils.replaceAll((String)url, (String)"\\s", (String)""));
            processorParameter.setOriginUrl(originUrl);
            processorParameter.setType(UrlTypeEnum.valueOf((String)urlTypeEnum));
            processorParameter.setProcessorEnum(ProcessorEnum.valueOf((String)processorEnumName));
            processorParameter.setJsonObject(object);
            processorParameter.setPersistenceEnum(PersistenceEnum.valueOf((String)persistenceType));
            downLoadParam.setProcessorParameter(processorParameter);
            downLoadParam.setPretreatmentEnum(pretreatmentEnum);
            downLoadParam.setPretreatmentParam(pretreatmentParam);
            downLoadParam.setCharset(charset);
            downLoadParam.setUserAgent(userAgent);
            downLoadParam.setCookie(cookie);
            downLoadParam.setChannel(channel);
            downLoadParam.setReferer(referer);
            downLoadParam.setProxyFlag(proxyFlag);
            downLoadParam.setLoginAccountParams(LoginAccountParamList);
            return downLoadParam;
        }
        catch (Exception e) {
            logger.error("ofDownloadDto error : ", (Throwable)e);
            return null;
        }
    }

    public static String getSaveUrl(String originUrl, String url) {
        return StringUtils.join((Object[])new String[]{originUrl, url}, (String)Constant.URL_JOINT_CHAR);
    }
}

