/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.spider.prod.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Properties;

/**
 * 调度配置类
 *
 * @ClassName QuartzConfigProperties
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/18 17:06
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/18 17:06
 **/
@Component
public class QuartzConfigProperties {
    @Autowired
    private JobFactory jobFactory;

    /**配置集群时，quartz调度器的id，由于配置集群时，只有一个调度器，必须保证每个服务器该值都相同，可以不用修改，只要每个ams都一样就行*/
    @Value("${org.quartz.scheduler.instanceName}")
    private String  quartzInstanceName;
    /**集群中每台服务器自己的id，AUTO表示自动生成，无需修改*/
    @Value("${org.quartz.scheduler.instanceId}")
    private String  instanceId;
    @Value("${org.quartz.scheduler.skipUpdateCheck}")
    private String  skipUpdateCheck;
    @Value("${org.quartz.scheduler.jmx.export}")
    private String  export;

    /**quartz线程池的实现类，无需修改*/
    @Value("${org.quartz.threadPool.class}")
    private String  threadPoolClass;
    @Value("${org.quartz.threadPool.threadCount}")
    private String  threadCount;
    @Value("${org.quartz.threadPool.threadPriority}")
    private String  threadPriority;
    @Value("${org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread}")
    private String  threadsInheritContextClassLoaderOfInitializingThread;

    /**表示如果某个任务到达执行时间，而此时线程池中没有可用线程时，任务等待的最大时间，
     * 如果等待时间超过下面配置的值(毫秒)，本次就不在执行，
     * 而等待下一次执行时间的到来，可根据任务量和负责程度来调整
     */
    @Value("${org.quartz.jobStore.misfireThreshold}")
    private String  misfireThreshold;
    @Value("${org.quartz.jobStore.class}")
    private String  jobStoreClass;
    @Value("${org.quartz.jobStore.tablePrefix}")
    private String  tablePrefix;
    @Value("${org.quartz.jobStore.dataSource}")
    private String  dataSource;
    @Value("${org.quartz.jobStore.isClustered}")
    private String  isClustered;
    @Value("${org.quartz.jobStore.clusterCheckinInterval}")
    private String  clusterCheckinInterval;
    @Value("${org.quartz.jobStore.driverDelegateClass}")
    private String  driverDelegateClass;
    @Value("${org.quartz.jobStore.maxMisfiresToHandleAtATime}")
    private String  maxMisfiresToHandleAtATime;
    @Value("${org.quartz.jobStore.txIsolationLevelSerializable}")
    private String  txIsolationLevelSerializable;
    @Value("${org.quartz.jobStore.selectWithLockSQL}")
    private String  selectWithLockSQL;

    @Value("${org.quartz.plugin.triggHistory.class}")
    private String  triggHistoryClass;
    @Value("${org.quartz.plugin.shutdownhook.class}")
    private String  shutdownhookClass;
    @Value("${org.quartz.plugin.shutdownhook.cleanShutdown}")
    private String  cleanShutdown;

    @Value("${org.quartz.dataSource.myDS.driver}")
    private String  driver;
    @Value("${org.quartz.dataSource.myDS.URL}")
    private String  URL;
    @Value("${org.quartz.dataSource.myDS.user}")
    private String  user;
    @Value("${org.quartz.dataSource.myDS.password}")
    private String  password;
    @Value("${org.quartz.dataSource.myDS.maxConnections}")
    private String  maxConnections;
    @Value("${org.quartz.dataSource.myDS.max-active}")
    private int     maxActive;
    @Value("${org.quartz.dataSource.myDS.min-idle}")
    private int     minIdle;
    @Value("${org.quartz.dataSource.myDS.initial-size}")
    private int     initialSize;
    @Value("${org.quartz.dataSource.myDS.test-on-borrow}")
    private boolean testOnBorrow;

    /**
     * 设置属性
     * 
     * @return
     * @throws IOException
     */
    private Properties quartzProperties() throws IOException {
        Properties prop = new Properties();
        prop.put("quartz.scheduler.instanceName", quartzInstanceName);
        prop.put("org.quartz.scheduler.instanceId", instanceId);
        prop.put("org.quartz.scheduler.skipUpdateCheck", skipUpdateCheck);
        prop.put("org.quartz.scheduler.jmx.export", export);

        prop.put("org.quartz.jobStore.class", jobStoreClass);
        prop.put("org.quartz.jobStore.driverDelegateClass", driverDelegateClass);
        prop.put("org.quartz.jobStore.dataSource", dataSource);
        prop.put("org.quartz.jobStore.tablePrefix", tablePrefix);
        prop.put("org.quartz.jobStore.isClustered", isClustered);
        prop.put("org.quartz.jobStore.clusterCheckinInterval", clusterCheckinInterval);
        prop.put("org.quartz.jobStore.maxMisfiresToHandleAtATime", maxMisfiresToHandleAtATime);
        prop.put("org.quartz.jobStore.misfireThreshold", misfireThreshold);
        prop.put("org.quartz.jobStore.txIsolationLevelSerializable", txIsolationLevelSerializable);
        prop.put("org.quartz.jobStore.selectWithLockSQL", selectWithLockSQL);

        prop.put("org.quartz.threadPool.class", threadPoolClass);
        prop.put("org.quartz.threadPool.threadCount", threadCount);
        prop.put("org.quartz.threadPool.threadPriority", threadPriority);
        prop.put("org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread",
                 threadsInheritContextClassLoaderOfInitializingThread);

        prop.put("org.quartz.dataSource.myDS.driver", driver);
        prop.put("org.quartz.dataSource.myDS.URL", URL);
        prop.put("org.quartz.dataSource.myDS.user", user);
        prop.put("org.quartz.dataSource.myDS.password", password);
        prop.put("org.quartz.dataSource.myDS.maxConnections", maxConnections);

        prop.put("org.quartz.plugin.triggHistory.class", triggHistoryClass);
        prop.put("org.quartz.plugin.shutdownhook.class", shutdownhookClass);
        prop.put("org.quartz.plugin.shutdownhook.cleanShutdown", cleanShutdown);

        return prop;
    }

    @Bean
    public SchedulerFactoryBean schedulerFactoryBean() throws IOException {
        SchedulerFactoryBean factory = new SchedulerFactoryBean();
        // this allows to update triggers in DB when updating settings in config file:
        // 用于quartz集群,QuartzScheduler 启动时更新己存在的Job，这样就不用每次修改targetObject后删除qrtz_job_details表对应记录了
        factory.setOverwriteExistingJobs(true);
        factory.setJobFactory(jobFactory);
        // QuartzScheduler 延时启动，应用启动完10秒后 QuartzScheduler 再启动
        factory.setStartupDelay(10);
        // 用于quartz集群,加载quartz数据源配置
        factory.setQuartzProperties(quartzProperties());
        factory.setAutoStartup(true);
        factory.setApplicationContextSchedulerContextKey("applicationContext");
        return factory;
    }
}
