package com.bxm.spider.prod.job;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.bxm.spider.cache.RedisClient;
import com.bxm.spider.cache.constant.TaskKeyConstant;
import com.bxm.spider.prod.model.dao.UrlConfig;
import com.bxm.spider.prod.common.constants.ConfigStatusEnum;
import com.bxm.spider.prod.common.constants.Constant;
import com.bxm.spider.prod.service.UrlConfigService;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 主任务默认控制job
 *
 * @ClassName SpiderJob
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/18 17:17
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/18 17:17
 **/
public class SpiderJob extends ProdJob {

    private Logger logger = LoggerFactory.getLogger(SpiderJob.class);

    @Autowired
    private UrlConfigService urlConfigService;

    @Autowired
    private RedisClient redisClient;

    /**
     * 爬虫执行job
     * 每次任务触发，都会将种子url推送到列表url队列中，种子url及其他列表url不计入已下载记录中
     *
     * @param jobExecutionContext
     * @return void
     * @throws
     * @author kk.xie
     * @date 2018/10/18 17:20
     */
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        // 取任务的流水号
        String serialNum = jobDataMap.getString(Constant.SERIAL_NUM);
        // 删除列表url爬取深度缓存
        redisClient.del(TaskKeyConstant.getDepthCatchHash(serialNum));
        // 单周期已下载列表队列
        // PS: 已下载详情队列，待下载列表队列与待下载详情队列不清空，跟随整个任务
        redisClient.del(TaskKeyConstant.getQueueCatchSet(serialNum));

        if(StringUtils.isEmpty(redisClient.hGet(TaskKeyConstant.getTaskExecutingHash(), serialNum))){
            redisClient.hSet(TaskKeyConstant.getTaskExecutingHash(), serialNum, "EXECUTING");
        }

        // 添加列表url到列表队列中
        List<UrlConfig> urlConfigList = urlConfigService.selectList(new EntityWrapper()
                .eq("serial_num", serialNum)
                .eq("status", ConfigStatusEnum.USABLE.getCode()));
        for(UrlConfig urlConfig : urlConfigList){
            String queueUrl = urlConfig.getUrl();
            redisClient.rpush(TaskKeyConstant.getQueueList(serialNum), queueUrl);
            logger.info("execute job: {}, add field {} to redis key {} success!", jobExecutionContext.getJobDetail().getKey(), queueUrl, TaskKeyConstant.getQueueList(serialNum));
        }
    }
}

