package com.bxm.spider.prod.service;

import org.quartz.Job;

/**
 * 任务维护
 *
 * @ClassName JobService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/18 16:45
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/18 16:45
 **/
public interface JobService {
    /**
     * 添加一个定时任务
     *
     * @param jobName
     * @return boolean
     * @throws
     * @author kk.xie
     * @date 2018/10/20 15:51
     */
    boolean addCronJob(String jobName);

    /**
     * 添加一个定时任务
     *
     * @param jobName 任务名称
     * @param jobClass 主任务执行类
     * @param jobQueueClass 列表任务执行类
     * @param jobDetailsClass 详情任务执行类
     * @return boolean
     * @throws
     * @author kk.xie
     * @date 2018/10/24 20:46
     */
    boolean addCronJob(String jobName, Class <? extends Job> jobClass, Class <? extends Job> jobQueueClass, Class <? extends Job> jobDetailsClass);

    /**
     * 暂停任务
     *
     * @param jobName
     * @return boolean
     * @throws
     * @author kk.xie
     * @date 2018/10/20 15:51
     */
    boolean pauseJob(String jobName);

    /**
     * 恢复任务
     *
     * @param jobName
     * @return boolean
     * @throws
     * @author kk.xie
     * @date 2018/10/20 15:51
     */
    boolean resumeJob(String jobName);

    /**
     * 删除job
     *
     * @param jobName
     * @return boolean
     * @throws
     * @author kk.xie
     * @date 2018/10/20 15:52
     */
    boolean deleteJob(String jobName);

    /**
     * 重启所有的任务
     *
     * @param
     * @return boolean
     * @throws
     * @author kk.xie
     * @date 2018/12/10 17:13
     */
    boolean restartAllJob();
}
