package com.bxm.spider.constant.processor;

/**
 * 过滤策略枚举
 *
 * @ClassName FilterTypeEnum
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author stephen
 * @Date 2019/02/25 11:11
 * @Version 1.0
 **/
public enum FilterTypeEnum {

    /**敏感词*/
    MINGGANCI(0, "MINGGANCI"),
    /**指定内容删除*/
    ZHIDING(1, "ZHIDING"),
    /**指定内容及之后的内容删除*/
    ZHIDINGZHIHOU(2, "ZHIDINGZHIHOU"),
    /**包含某个字段直接下线*/
    BAOHAN(3, "BAOHAN"),
    /**某个字段开头直接下线*/
    KAITOU(4, "KAITOU")
    ;

    private Integer code;
    private String name;

    FilterTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
