package com.bxm.spider.constant.task;

/**
 * 任务执行状态枚举
 *
 * @ClassName TaskStatusEnum
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/24 21:01
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/24 21:01
 **/
public enum TaskStatusEnum {
    WAIT_START("待启动", 1),
    RUNNING("运行中", 2),
    PAUSE("暂停", 3),
    STOP("停止", 4);

    /**
     * 枚举-名称
     */
    private String name;

    /**
     * 枚举-编码
     */
    private Integer code;

    TaskStatusEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public Integer getCode() {
        return code;
    }
}
