package com.bxm.spider.constant.exception;


import org.apache.commons.lang3.StringUtils;

/**
 * <p> 自定义异常类</p>
 *
 * @Author: JandMin
 * @Date: 2018/7/25
 */
public class BaseRunException extends RuntimeException{
    private static final long serialVersionUID = 1L;

    private String msg;

    public BaseRunException(String mess, Exception ex) {
        super(mess,ex);
        this.setMsg(mess);
    }
    public BaseRunException(String mess) {
        super(mess);
        this.setMsg(mess);
    }
    public String getMsg() {
        if(StringUtils.isBlank(msg)){
            msg = "empty error message!";
        }
        return msg;
    }
    public void setMsg(String msg) {
        this.msg = msg;
    }
}
