package com.bxm.spider.constant.monitor;

import com.alibaba.fastjson.JSON;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.constant.url.UrlTypeEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * 监控日志返回帮助类
 *
 * @ClassName MonitorHelper
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author stephen
 * @Date 2018/12/19 11:11
 * @Version 1.0
 **/
public class MonitorHelper {

    /**
     * 监控成功日志
     *
     * @param monitorFlow MonitorConstant 中的调度过程
     * @param serialNum   任务流水号
     * @param urlType     url类型
     * @return
     */
    public static String ofSuccessLog(String monitorFlow, String serialNum, UrlTypeEnum urlType) {
        MonitorLogDto monitorLogDto = new MonitorLogDto();
        monitorLogDto.setSuccess(true);
        monitorLogDto.setSerialNum(serialNum);
        monitorLogDto.setMonitorFlow(monitorFlow);
        monitorLogDto.setUrlType(urlType.name());

        return MonitorConstant.MONITOR_PREFIX + JSON.toJSONString(monitorLogDto) + MonitorConstant.MONITOR_SUFFIX;
    }

    /**
     * 监控错误日志
     *
     * @param monitorFlow  MonitorConstant 中的调度过程
     * @param serialNum    任务流水号
     * @param urlType      url类型
     * @param error        ErrorEnum 中的错误类型
     * @param errorMessage 错误信息，默认使用ErrorEnum中的错误信息
     * @return
     */
    public static String ofFailLog(String monitorFlow, String serialNum, UrlTypeEnum urlType, ErrorEnum error, String errorMessage) {
        if (null == error) {
            return "";
        }

        MonitorLogDto monitorLogDto = new MonitorLogDto();
        monitorLogDto.setSuccess(false);
        monitorLogDto.setSerialNum(serialNum);
        monitorLogDto.setMonitorFlow(monitorFlow);
        monitorLogDto.setUrlType(urlType.name());
        monitorLogDto.setErrorCode(error.getCode());
        if (StringUtils.isBlank(errorMessage)) {
            monitorLogDto.setErrorMessage(error.getName());
        } else {
            monitorLogDto.setErrorMessage(errorMessage);
        }

        return MonitorConstant.MONITOR_PREFIX + JSON.toJSONString(monitorLogDto) + MonitorConstant.MONITOR_SUFFIX;
    }


    /**
     * 监控成功日志
     *
     * @param monitorFlow        MonitorConstant 中的调度过程
     * @param processorParameter 应用之间传递的参数
     * @return
     */
    public static String ofSuccessLog(String monitorFlow, ProcessorParameter processorParameter) {
        if (null == processorParameter) {
            return "";
        }

        return ofSuccessLog(monitorFlow, processorParameter.getSerialNum(), processorParameter.getType());
    }

    /**
     * 监控错误日志
     *
     * @param monitorFlow        MonitorConstant 中的调度过程
     * @param processorParameter 应用之间传递的参数
     * @param error              ErrorEnum 中的错误类型
     * @param errorMessage       错误信息，默认使用ErrorEnum中的错误信息
     * @return
     */
    public static String ofFailLog(String monitorFlow, ProcessorParameter processorParameter, ErrorEnum error, String errorMessage) {
        if (null == processorParameter) {
            return "";
        }

        return ofFailLog(monitorFlow, processorParameter.getSerialNum(), processorParameter.getType(), error, errorMessage);
    }

}
