package com.bxm.spider.constant.processor;

/**
 * <p>
 *     评论内容解析器枚举类
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/3/6
 */
public enum CommentEnum {
    /** 通用新闻网页评论解析器 */
    HTML(1,"HTML"),
    /** 新浪评论 */
    SINA(2,"SINA"),
    /** 网易评论 */
    NETEASE(3,"NETEASE"),
    /** 头条评论 */
    TOUTIAO(4,"TOUTIAO"),
    /** 搜狐评论 */
    SOHU(5,"SOHU"),
    /** 腾讯评论 */
    TENCENT(6,"TENCENT"),
    /** 抖音评论 */
    DOUYIN(7,"DOUYIN"),
    /** 微博评论 */
    WEIBO(8,"WEIBO"),
    /** 108社区 */
    SQ108(8,"SQ108"),
    ;

    private Integer code;
    private String name;

    CommentEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
