package com.bxm.spider.constant.processor;

/**
 * @author zhaoxin
 */
public enum PretreatmentEnum {
    /**
     * url参数预处理（url中拼接动态参数）
     */
    URL,

    /**
     * cookie参数预处理（cookie动态参数）
     */
    COOKIE,

    /**
     * 登陆获取用户信息用于后续操作
     */
    LOGIN,

    /**
     * 抖音预处理（来源为今日头条中的小视频模块，实则为西瓜视频）
     */
    DOUYIN,

    /**
     * 优惠券预处理
     */
    COUPON,

    /**
     * 微信公众账号获取预处理
     */
    WECHAT_ACCOUNT,

    /**
     * 微信内容抓取预处理
     */
    WECHAT_CONTENT,

    /**
     * 猎奇网预处理
     */
    LIEQI,

    /**
     * 抖音预处理
     */
    TIKTOK,

    /**
     * 年糕小程序抓取预处理
     */
    NIANGAO,

    /**
     * 今日家园
     */
    HOME_TODAY,

    /**
     * 列表url请求转化为详情url请求
     * 用于直接获取列表中返回详情信息的站点
     */
    LIST_TO_DETAIL,

    /**
     * 快手预处理
     */
    KUAISHOU,

    /**
     * 百度好看视频预处理
     */
    BAIDU_SV,

    /**
     * 凤凰新闻-APP
     */
    IFENG,

    /**
     * 设置不下载
     */
    NOT_DOWNLOAD,
    ;
}
