package com.bxm.spider.constant.processor;

/**
 * 处理器枚举-选择需要使用的处理器
 *
 * @author zhaoxin
 **/
public enum ProcessorEnum {
    /**
     * 通用html处理器
     */
    HTML,

    /**
     * 快音视处理器
     */
    KUAIYINSHI,

    /**
     * 微信处理器
     */
    WECHAT,

    /**
     * 头条小视频处理器
     */
    DOUYIN,

    /**
     * 头条处理器
     */
    TOUTIAO,

    /**
     * 图片处理器
     */
    IMAGE,

    /**
     * 大淘客处理器
     */
    DATAOKE,

    /**
     * 微信公众号处理器
     */
    WECHATACCOUNT,

    /**
     * 微信公众号新闻处理器
     */
    WECHATNEWS,

    /**
     * 猎奇新闻处理器
     */
    LIEQI,

    /**
     * 梨视频处理器
     */
    PEARVIDEO,

    /**
     * 优美
     */
    YOUMEI,

    /**
     * 抖音
     */
    TIKTOK,

    /**
     * 腾讯新闻客户端
     */
    TENCENTNEWS,

    /**
     * 微博
     */
    WEIBO,

    /**
     * 今日家园
     */
    HOMETODAY,

    /**
     * 年糕小程序
     */
    NIANGAO,

    /**
     * 快手小程序处理
     */
    KUAISHOU,

    /**
     * 百度好看视频
     */
    BAIDU_SV,

    /**
     * 西瓜视频APP抓取
     */
    XIGUA,
    /**
     * 凤凰新闻APP
     */
    IFENG,

    /**
     * 马甲号微博来源帖子处理器
     */
    FORUM_POST_WEIBO,
    /**
     * 马甲号108社区来源帖子处理器
     */
    FORUM_POST_108SQ,
    /**
     * 马甲号19楼来源帖子处理器
     */
    FORUM_POST_19LOU
    ;
}
