package com.bxm.spider.constant.processor;

import com.bxm.spider.constant.url.UrlTypeEnum;

import java.io.Serializable;

/**
 * <p> 应用之间传递的参数 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/11/19
 */
public class ProcessorParameter implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 当前下载的url
     */
    private String      url;
    /**
     * 种子url
     */
    private String      originUrl;
    /**
     * 下载任务的任务流水号
     */
    private String      serialNum;
    /**
     * url类型: 1-列表url 2-详情url
     * 用枚举类实现
     */
    private UrlTypeEnum type;
    /**
     * 处理器枚举-指定使用哪个处理器进行业务处理
     */
    private ProcessorEnum processorEnum;
    /**
     * 存储器枚举
     */
    private PersistenceEnum persistenceEnum;
    /**
     * 评论处理器枚举
     */
    private CommentEnum commentEnum;
    /**
     * 封装 json 的对象
     */
    private String jsonObject;

    public CommentEnum getCommentEnum() {
        return commentEnum;
    }

    public void setCommentEnum(CommentEnum commentEnum) {
        this.commentEnum = commentEnum;
    }

    public PersistenceEnum getPersistenceEnum() {
        return persistenceEnum;
    }

    public void setPersistenceEnum(PersistenceEnum persistenceEnum) {
        this.persistenceEnum = persistenceEnum;
    }

    public String getJsonObject() {
        return jsonObject;
    }

    public void setJsonObject(String jsonObject) {
        this.jsonObject = jsonObject;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOriginUrl() {
        return originUrl;
    }

    public void setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
    }

    public String getSerialNum() {
        return serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public UrlTypeEnum getType() {
        return type;
    }

    public void setType(UrlTypeEnum type) {
        this.type = type;
    }

    public ProcessorEnum getProcessorEnum() {
        return processorEnum;
    }

    public void setProcessorEnum(ProcessorEnum processorEnum) {
        this.processorEnum = processorEnum;
    }

    @Override
    public String toString() {
        return "ProcessorParameter{" +
                "url='" + url + '\'' +
                ", originUrl='" + originUrl + '\'' +
                ", serialNum='" + serialNum + '\'' +
                ", type=" + type +
                ", processorEnum=" + processorEnum +
                ", persistenceEnum=" + persistenceEnum +
                ", commentEnum=" + commentEnum +
                ", jsonObject='" + jsonObject + '\'' +
                '}';
    }
}
