/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.response;

import com.bxm.spider.response.ResponseModel;

public final class ResponseModelFactory {
    private ResponseModelFactory() {
    }

    public static <T> ResponseModel<T> getResponseModel() {
        return ResponseModel.newInstance();
    }

    public static <T> ResponseModel<T> SUCCESS(T data) {
        return ResponseModelFactory.SUCCESS(data, ResponseCode.SUCCESS.code, ResponseCode.SUCCESS.message);
    }

    public static <T> ResponseModel<T> SUCCESS(T data, Integer code, String message) {
        return ResponseModelFactory.getResponseModel(data, true, code, message);
    }

    public static <T> ResponseModel<T> FAILED() {
        return ResponseModelFactory.FAILED(ResponseCode.ERROR.code, ResponseCode.ERROR.message);
    }

    public static <T> ResponseModel<T> FAILED400() {
        return ResponseModelFactory.FAILED(ResponseCode.REQUEST_ERROR.code, ResponseCode.REQUEST_ERROR.message);
    }

    public static <T> ResponseModel<T> FAILED401() {
        return ResponseModelFactory.FAILED(ResponseCode.LOGIN_ERROR.code, ResponseCode.LOGIN_ERROR.message);
    }

    public static <T> ResponseModel<T> FAILED408() {
        return ResponseModelFactory.FAILED(ResponseCode.TIMEOUT_ERROR.code, ResponseCode.TIMEOUT_ERROR.message);
    }

    public static <T> ResponseModel<T> FAILED500() {
        return ResponseModelFactory.FAILED(ResponseCode.SYSTEM_ERROR.code, ResponseCode.SYSTEM_ERROR.message);
    }

    public static <T> ResponseModel<T> FAILED(Integer code, String message) {
        return ResponseModelFactory.getResponseModel(null, false, code, message);
    }

    public static <T> ResponseModel<T> getResponseModel(T data, boolean success, Integer code, String message) {
        ResponseModel<T> response = ResponseModelFactory.getResponseModel();
        response.setSuccess(success);
        response.setError(!success);
        response.setCode(code);
        response.setMessage(message);
        if (null != data) {
            response.setData(data);
        }
        return response;
    }

    public static enum ResponseCode {
        SUCCESS(1, "\u6210\u529f"),
        ERROR(0, "\u5931\u8d25"),
        REQUEST_ERROR(400, "the parameters error"),
        LOGIN_ERROR(401, "login error"),
        TIMEOUT_ERROR(408, "login error"),
        SYSTEM_ERROR(500, "system error");

        Integer code;
        String message;

        public Integer getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        private ResponseCode(Integer code, String message) {
            this.code = code;
            this.message = message;
        }
    }
}

