/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.utils;

import com.bxm.spider.utils.inner.IntervalMap;
import com.bxm.spider.utils.inner.Lunar;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    public static final long SECONDS_OF_DAY = 86400L;
    public static final long WEEK_MILLISECOND = 604800000L;
    public static final long DAY_MILLISECOND = 86400000L;
    public static final long HOUR_MILLISECOND = 3600000L;
    public static final long MINUTE_MILLISECOND = 60000L;
    public static final String PATTERN_STR8 = "yyyyMMdd";
    public static final String PATTERN_STR10 = "yyyy-MM-dd";
    public static final String PATTERN_STR14 = "yyyyMMddHHmmss";
    public static final String PATTERN_STR19 = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DAY_HOUR_MUNITE = "yyyy-MM-dd HH:mm";
    public static final String DAY_HOUR_MINUTE_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_YEAR_MONTH_DAY_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    private static final String ONE_SECOND_AGO = "\u51e0\u79d2\u524d";
    private static final String ONE_MINUTE_AGO = "\u5206\u949f\u524d";
    private static final String ONE_HOUR_AGO = "\u5c0f\u65f6\u524d";
    private static final String YESTERDAY = "\u6628\u5929";
    private static final String ONE_DAY_AGO = "\u5929\u524d";
    private static final String ONE_WEEK_AGO = "\u5468\u524d";
    private static final String ONE_MONTH_AGO = "\u6708\u524d";
    private static final String ONE_YEAR_AGO = "\u5e74\u524d";
    public static ThreadLocal<DateFormat> DATE_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat(PATTERN_STR10));
    public static ThreadLocal<DateFormat> DATE_TIME_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    public static ThreadLocal<DateFormat> ISO_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
    public static ThreadLocal<DateFormat> DATE_HOUR_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH"));
    public static ThreadLocal<DateFormat> DATE_TIME_SECOND_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat(PATTERN_STR14));
    public static ThreadLocal<DateFormat> DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMddHHmmsssss"));
    public static ThreadLocal<DateFormat> PATTERN_NO_DELIMITER_WITHOUT_DAY_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMM"));
    public static ThreadLocal<DateFormat> PATTERN_NO_DELIMITER_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(PATTERN_STR8));
    public static ThreadLocal<DateFormat> PATTERN_MONTH_DAY_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("MM-dd"));
    public static ThreadLocal<DateFormat> PATTERN_YEAR_MONTH_DAY_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_FORMAT_YEAR_MONTH_DAY_FORMAT));
    private static List<ThreadLocal<DateFormat>> FORMAT_LIST = new ArrayList<ThreadLocal<DateFormat>>();

    private DateUtils() {
    }

    public static Date addField(Date date, int field, int amount) {
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(date);
        sourceCalendar.add(field, amount);
        return sourceCalendar.getTime();
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return PATTERN_NO_DELIMITER_FORMAT.get().format(date);
    }

    public static String formatAtWill(Date source, String formatPatter) {
        if (null == source) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(formatPatter);
        return format.format(source);
    }

    public static String formatDateNonStrict(Date date) {
        String result = null;
        if (null == date) {
            return null;
        }
        for (ThreadLocal<DateFormat> supportFormatLocal : FORMAT_LIST) {
            result = supportFormatLocal.get().format(date);
            if (!StringUtils.isNotBlank((CharSequence)result)) continue;
            return result;
        }
        return result;
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DATE_TIME_FORMAT_THREAD_LOCAL.get().format(date);
    }

    public static String formatDateHour(Date date) {
        if (null == date) {
            return null;
        }
        return DATE_HOUR_FORMAT_THREAD_LOCAL.get().format(date);
    }

    public static String getMilliSecondDate() {
        return DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL.get().format(System.currentTimeMillis());
    }

    public static Date parseDate(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        try {
            return DATE_FORMAT_THREAD_LOCAL.get().parse(source);
        }
        catch (ParseException e) {
            LOGGER.info(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Date parseDateNonStrict(String source) {
        if (null == source) {
            return null;
        }
        if (NumberUtils.isDigits((String)source) && source.length() == 13) {
            return new Date(Long.valueOf(source));
        }
        Date result = null;
        for (ThreadLocal<DateFormat> supportFormatLocal : FORMAT_LIST) {
            try {
                result = supportFormatLocal.get().parse(source);
                if (null == result) continue;
                return result;
            }
            catch (ParseException parseException) {
            }
        }
        return result;
    }

    public static Date parseDateTime(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        try {
            return DATE_TIME_FORMAT_THREAD_LOCAL.get().parse(source);
        }
        catch (ParseException e) {
            LOGGER.info(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws ParseException {
        String str = "19.00";
        System.out.println(str.substring(0, str.indexOf(".")));
    }

    public static Date parse(String source) {
        Date parseResult;
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        try {
            parseResult = DATE_TIME_FORMAT_THREAD_LOCAL.get().parse(source);
        }
        catch (ParseException e) {
            parseResult = null;
        }
        try {
            if (null == parseResult) {
                parseResult = DATE_FORMAT_THREAD_LOCAL.get().parse(source);
            }
        }
        catch (ParseException e) {
            parseResult = null;
        }
        if (null == parseResult) {
            LOGGER.info("\u4e0d\u652f\u6301\u8be5\u683c\u5f0f\u7684\u65e5\u671f\u8f6c\u6362\uff0c\u6e90\u6570\u636e\u4e3a[{}]", (Object)source);
        }
        return parseResult;
    }

    public static String getCurrentDate() {
        return DateUtils.formatDate(new Date());
    }

    public static String getCurrentDateTime() {
        return DateUtils.formatDateTime(new Date());
    }

    public static Date getClearDate(Date date) {
        if (null == date) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.clearTimePart(calendar);
        return calendar.getTime();
    }

    public static boolean before(Date when) {
        return DateUtils.after(new Date(), when);
    }

    public static boolean after(Date when) {
        return DateUtils.after(when, new Date());
    }

    public static boolean before(Date source, Date target) {
        return DateUtils.after(target, source);
    }

    public static boolean after(Date source, Date target) {
        if (null == source || null == target) {
            return false;
        }
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(source);
        return source.after(target);
    }

    public static int getField(Date date, int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(field);
    }

    public static Date setField(Date date, int field, int amount) {
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(date);
        sourceCalendar.set(field, sourceCalendar.get(field) + amount);
        return sourceCalendar.getTime();
    }

    public static int getDiffMonths(Date source, Date target) {
        if (null == source || null == target) {
            return 0;
        }
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(source);
        Calendar targetCalendar = Calendar.getInstance();
        targetCalendar.setTime(target);
        int sourceYear = sourceCalendar.get(1);
        int sourceMonth = sourceCalendar.get(2);
        int targetYear = targetCalendar.get(1);
        int targetMonth = targetCalendar.get(2);
        int diffMonth = sourceYear * 12 + sourceMonth - (targetYear * 12 + targetMonth);
        return Math.abs(diffMonth);
    }

    public static int getDiffDays(Date source, Date target, boolean abs) {
        if (null == source || null == target) {
            return 0;
        }
        long diffSeconed = source.getTime() - target.getTime();
        if (abs) {
            diffSeconed = Math.abs(diffSeconed);
        }
        return (int)(diffSeconed / 86400000L);
    }

    public static long getDiffHours(Date source, Date target, boolean abs) {
        if (null == source || null == target) {
            return 0L;
        }
        long diffSeconed = source.getTime() - target.getTime();
        if (abs) {
            diffSeconed = Math.abs(diffSeconed);
        }
        return Math.abs(diffSeconed / 3600000L);
    }

    public static long getDiffMinutes(Date source, Date target) {
        return DateUtils.getDiffMinutes(source, target, true);
    }

    public static long getDiffMinutes(Date source, Date target, boolean abs) {
        if (null == source || null == target) {
            return 0L;
        }
        long diffSeconed = source.getTime() - target.getTime();
        if (abs) {
            diffSeconed = Math.abs(diffSeconed);
        }
        return diffSeconed / 60000L;
    }

    public static long getDiffSeconed(Date source, Date target, boolean abs) {
        if (null == source || null == target) {
            return 0L;
        }
        long diffSeconed = (source.getTime() - target.getTime()) / 1000L;
        if (abs) {
            return Math.abs(diffSeconed);
        }
        return diffSeconed;
    }

    public static int getDiffYears(Date source, Date target) {
        if (null == source || null == target) {
            return 0;
        }
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(source);
        Calendar targetCalendar = Calendar.getInstance();
        targetCalendar.setTime(target);
        int diffYears = targetCalendar.get(1) - sourceCalendar.get(1);
        diffYears = Math.abs(diffYears);
        if (targetCalendar.get(2) < sourceCalendar.get(2)) {
            --diffYears;
        } else if (targetCalendar.get(2) == sourceCalendar.get(2) && targetCalendar.get(5) < sourceCalendar.get(5)) {
            --diffYears;
        }
        return diffYears;
    }

    public static Lunar getChineseLunar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new Lunar(calendar);
    }

    public static IntervalMap getInterval(Interval interval) {
        return DateUtils.getInterval(interval, new Date());
    }

    public static Date getWeekStartDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 2);
        DateUtils.clearTimePart(cal);
        return cal.getTime();
    }

    public static IntervalMap getInterval(Interval interval, Date date) {
        Date startTime = null;
        Date endTime = null;
        if (null == interval || null == date) {
            return new IntervalMap(null, null);
        }
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        switch (interval) {
            case TODAY: {
                startCalendar.setTime(date);
                endCalendar.setTime(date);
                endCalendar.add(6, 1);
                break;
            }
            case TOMORROW: {
                startCalendar.setTime(date);
                startCalendar.add(6, 1);
                endCalendar.setTime(date);
                endCalendar.add(6, 2);
                break;
            }
            case YESTERDAY: {
                startCalendar.setTime(date);
                startCalendar.add(6, -1);
                endCalendar.setTime(date);
                break;
            }
            case THREE_DAY: {
                startCalendar.setTime(date);
                startCalendar.add(6, -3);
                endCalendar.setTime(date);
                break;
            }
            case FIVE_DAY: {
                startCalendar.setTime(date);
                startCalendar.add(6, -5);
                endCalendar.setTime(date);
                break;
            }
            case SEVEN_DAY: {
                startCalendar.setTime(date);
                startCalendar.add(6, -7);
                endCalendar.setTime(date);
                break;
            }
            case WEEK: {
                boolean isSunday;
                startCalendar.setTime(date);
                boolean bl = isSunday = startCalendar.get(7) == 1;
                if (isSunday) {
                    startCalendar.add(3, -1);
                }
                startCalendar.set(7, 2);
                endCalendar.setTime(date);
                if (!isSunday) {
                    endCalendar.add(3, 1);
                }
                endCalendar.set(7, 1);
                break;
            }
            case MONTH: {
                startCalendar.setTime(date);
                startCalendar.set(5, 1);
                endCalendar.setTime(date);
                endCalendar.set(5, endCalendar.getActualMaximum(5));
                break;
            }
            case QUARTER: {
                startCalendar.setTime(date);
                endCalendar.setTime(date);
                int currentMonth = startCalendar.get(2);
                int startMonth = currentMonth % 3 * 3;
                int endMonth = startMonth + 2;
                startCalendar.set(2, startMonth);
                startCalendar.set(5, 1);
                endCalendar.set(2, endMonth);
                endCalendar.set(5, endCalendar.getActualMaximum(5));
                break;
            }
            case HALY_YEAR: {
                startCalendar.setTime(date);
                endCalendar.setTime(date);
                int currentMonth = startCalendar.get(2);
                int startMonth = currentMonth % 6 * 6;
                int endMonth = startMonth + 5;
                startCalendar.set(2, startMonth);
                startCalendar.set(5, 1);
                endCalendar.set(2, endMonth);
                endCalendar.set(5, endCalendar.getActualMaximum(5));
                break;
            }
            case YEAR: {
                startCalendar.setTime(date);
                startCalendar.set(2, 0);
                startCalendar.set(5, 1);
                endCalendar.setTime(date);
                endCalendar.set(2, 11);
                endCalendar.set(5, endCalendar.getActualMaximum(5));
                break;
            }
            case LAST_YEAR: {
                startCalendar.setTime(date);
                startCalendar.add(1, -1);
                startCalendar.set(2, 0);
                startCalendar.set(5, 1);
                endCalendar.setTime(date);
                endCalendar.add(1, -1);
                endCalendar.set(2, 11);
                endCalendar.set(5, endCalendar.getActualMaximum(5));
                break;
            }
            default: {
                return new IntervalMap(startTime, endTime);
            }
        }
        DateUtils.clearTimePart(startCalendar);
        DateUtils.clearTimePart(endCalendar);
        startTime = startCalendar.getTime();
        endTime = endCalendar.getTime();
        return new IntervalMap(startTime, endTime);
    }

    private static void clearTimePart(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static Date clearTimePart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.clearTimePart(calendar);
        return calendar.getTime();
    }

    public static String getTimeLag(Date date) {
        if (null == date) {
            return null;
        }
        long delta = System.currentTimeMillis() - date.getTime();
        if (delta < 60000L) {
            return ONE_SECOND_AGO;
        }
        if (delta < 3600000L) {
            long minutes = delta / 60000L;
            return (minutes <= 0L ? 1L : minutes) + ONE_MINUTE_AGO;
        }
        if (delta < 86400000L) {
            long hours = delta / 3600000L;
            return (hours <= 0L ? 1L : hours) + ONE_HOUR_AGO;
        }
        if (delta < 172800000L) {
            return YESTERDAY;
        }
        if (delta < 604800000L) {
            long days = delta / 86400000L;
            return (days <= 0L ? 1L : days) + ONE_DAY_AGO;
        }
        if (delta < 2592000000L) {
            long days = delta / 604800000L;
            return (days <= 0L ? 1L : days) + ONE_WEEK_AGO;
        }
        if (delta < 29030400000L) {
            long months = delta / 2592000000L;
            return (months <= 0L ? 1L : months) + ONE_MONTH_AGO;
        }
        long years = delta / 31536000000L;
        return (years <= 0L ? 1L : years) + ONE_YEAR_AGO;
    }

    public static long getRemainSecondsOfToday() {
        return DateUtils.getRemainSecondsOfDay(1);
    }

    public static long getRemainSecondsOfDay(int day) {
        return 86400L * (long)day - org.apache.commons.lang.time.DateUtils.getFragmentInSeconds((Calendar)Calendar.getInstance(), (int)5);
    }

    public static String getDate() {
        return DateUtils.format(PATTERN_STR8);
    }

    public static String format(String pattern) {
        return DateFormatUtils.format((Calendar)Calendar.getInstance(), (String)pattern);
    }

    public static String format(Date date, String pattern) {
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static Date parse(String date, String pattern) {
        try {
            return org.apache.commons.lang.time.DateUtils.parseDate((String)date, (String[])new String[]{pattern});
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getPreDate(String date) throws ParseException {
        return DateUtils.getDate(date, -1);
    }

    public static String getNextDate(String date) throws ParseException {
        return DateUtils.getDate(date, 1);
    }

    public static String getDate(String date, int count) throws ParseException {
        return DateUtils.getDate(date, count, PATTERN_STR10);
    }

    public static String getDate(String date, int count, String pattern) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat parser = new SimpleDateFormat(pattern);
        calendar.setTime(parser.parse(date));
        calendar.add(5, count);
        return parser.format(calendar.getTime());
    }

    public static String getDateFromToday(int count, String pattern) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, count);
        return DateFormatUtils.format((Date)calendar.getTime(), (String)pattern);
    }

    public static Date convertStringToDate(String strDate, String pattern) {
        if (StringUtils.isBlank((CharSequence)strDate) || StringUtils.isBlank((CharSequence)pattern)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String convertDateToString(Date date) {
        return DateUtils.convertDateToString(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String convertDateToString(Date date, String pattern) {
        if (date == null || StringUtils.isBlank((CharSequence)pattern)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        FORMAT_LIST.add(ISO_FORMAT_THREAD_LOCAL);
        FORMAT_LIST.add(DATE_TIME_FORMAT_THREAD_LOCAL);
        FORMAT_LIST.add(DATE_FORMAT_THREAD_LOCAL);
        FORMAT_LIST.add(DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL);
        FORMAT_LIST.add(DATE_TIME_SECOND_FORMAT_THREAD_LOCAL);
        FORMAT_LIST.add(DATE_HOUR_FORMAT_THREAD_LOCAL);
    }

    public static enum Interval {
        TODAY,
        TOMORROW,
        YESTERDAY,
        THREE_DAY,
        FIVE_DAY,
        SEVEN_DAY,
        WEEK,
        MONTH,
        QUARTER,
        HALY_YEAR,
        YEAR,
        LAST_YEAR;

    }
}

