/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.utils;

import com.bxm.spider.utils.dto.ExcelHeadModel;
import com.bxm.spider.utils.dto.ExportDataRow;
import com.bxm.spider.utils.dto.ExportModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.Region;

public class ExportUtils {
    private static HSSFWorkbook workbook = null;
    private static HSSFCellStyle titleDefaultStyle = null;
    private static HSSFCellStyle titleRedStyle = null;
    private static HSSFCellStyle dataStyle = null;
    private static final short EXCEL_TITLE_ROW_HEIGHT = 500;
    private static final short EXCEL_ROW_HEIGHT = 350;
    private static final short EXCEL_COLUMN_WIDTH_OF_CHAR = 350;
    private static final short EXCEL_COLUMN_MIN_WIDTH = 4500;
    private static final short FONT_SIZE = 10;
    private static final String FONT_NAME = "\u5b8b\u4f53";

    public static void exportToResponse(HttpServletResponse response, String fileName, byte[] output, String type) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(output);
        response.reset();
        if ("excel".equals(type)) {
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
        } else if ("zip".equals(type)) {
            response.setContentType("application/octet-stream;charset=utf-8");
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), "iso-8859-1"));
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    public static byte[] zipFile(Map<String, byte[]> fileMap) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(os);
        if (fileMap != null && CollectionUtils.isNotEmpty(fileMap.entrySet())) {
            for (Map.Entry<String, byte[]> fileEntry : fileMap.entrySet()) {
                ZipEntry zipEntry = new ZipEntry(fileEntry.getKey());
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(fileEntry.getValue(), 0, fileEntry.getValue().length);
                zipOutputStream.flush();
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
        }
        return os.toByteArray();
    }

    public static byte[] makeExcel(ExportModel exportModel, String fileName) throws Exception {
        workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        ExportUtils.setTitleCellStyles(workbook, sheet);
        sheet.autoSizeColumn(1);
        sheet.autoSizeColumn(1, true);
        ExportUtils.setDataCellStyles(workbook, sheet);
        List<ExcelHeadModel> excelHeadModels = ExportUtils.makeExcelTmp(exportModel);
        HashMap<String, String> mapHeads = new HashMap<String, String>();
        for (String headName : exportModel.getHeadNames().split(",")) {
            mapHeads.put(headName, headName);
        }
        ExportUtils.creatAppRowHead(sheet, 2, fileName, excelHeadModels);
        int i = 3;
        for (ExportDataRow exportDataRow : exportModel.getDataRowList()) {
            ExportUtils.creatAppRow(sheet, excelHeadModels, i, exportDataRow, mapHeads, i);
            ++i;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        workbook.write((OutputStream)os);
        return os.toByteArray();
    }

    private static void setTitleCellStyles(HSSFWorkbook workbook, HSSFSheet sheet) {
        titleDefaultStyle = workbook.createCellStyle();
        titleDefaultStyle.setBorderBottom((short)1);
        titleDefaultStyle.setBorderLeft((short)1);
        titleDefaultStyle.setBorderRight((short)1);
        titleDefaultStyle.setBorderTop((short)1);
        titleDefaultStyle.setFillForegroundColor((short)42);
        titleDefaultStyle.setFillPattern((short)1);
        titleDefaultStyle.setAlignment((short)2);
        titleDefaultStyle.setVerticalAlignment((short)1);
        HSSFFont font = workbook.createFont();
        font.setFontName(FONT_NAME);
        font.setFontHeightInPoints((short)10);
        font.setBoldweight((short)700);
        font.setColor((short)8);
        titleDefaultStyle.setFont(font);
        titleDefaultStyle.setWrapText(false);
    }

    private static void setDataCellStyles(HSSFWorkbook workbook, HSSFSheet sheet) {
        dataStyle = workbook.createCellStyle();
        dataStyle.setBorderBottom((short)1);
        dataStyle.setBorderLeft((short)1);
        dataStyle.setBorderRight((short)1);
        dataStyle.setBorderTop((short)1);
        dataStyle.setAlignment((short)2);
        dataStyle.setVerticalAlignment((short)1);
        HSSFFont font = workbook.createFont();
        font.setFontName(FONT_NAME);
        font.setBoldweight((short)700);
        font.setFontHeightInPoints((short)10);
        dataStyle.setFont(font);
        dataStyle.setWrapText(false);
    }

    private static void creatAppRowHead(HSSFSheet sheet, int rowIndex, String fileName, List<ExcelHeadModel> excelHeadModels) {
        HSSFRow rowTitle = sheet.createRow(rowIndex - 2);
        HSSFCell serialNumberCellTitle = rowTitle.createCell(0);
        serialNumberCellTitle.setCellValue(fileName);
        serialNumberCellTitle.setCellStyle(titleDefaultStyle);
        rowTitle.setHeight((short)500);
        sheet.addMergedRegion((Region)new org.apache.poi.hssf.util.Region(0, 0, 0, (short)excelHeadModels.size()));
        HSSFRow row = sheet.createRow(rowIndex - 1);
        HSSFCell serialNumberCell = row.createCell(0);
        serialNumberCell.setCellValue("\u5e8f\u53f7");
        serialNumberCell.setCellStyle(titleDefaultStyle);
        int index = 1;
        for (ExcelHeadModel excelHeadModel : excelHeadModels) {
            row.setHeight((short)500);
            HSSFCell cell = row.createCell(index);
            cell.setCellValue(excelHeadModel.getHeadName().trim());
            if (excelHeadModel.getHeadName().trim().indexOf("*") != -1) {
                cell.setCellStyle(titleRedStyle);
            } else {
                cell.setCellStyle(titleDefaultStyle);
            }
            ++index;
        }
    }

    private static void creatAppRow(HSSFSheet sheet, List<ExcelHeadModel> excelHeadModels, int num, ExportDataRow exportDataRow, Map<String, String> mapHeads, int rowIndex) throws Exception {
        HSSFRow row = sheet.createRow(rowIndex - 1);
        HSSFCell serialNumberCell = row.createCell(0);
        serialNumberCell.setCellValue((double)(num - 2));
        serialNumberCell.setCellStyle(titleDefaultStyle);
        int index = 1;
        for (String exportDataColumn : exportDataRow.getDataColumnList()) {
            HSSFCell cell = row.createCell(index);
            if (StringUtils.isNotBlank((String)exportDataColumn) && !StringUtils.equals((String)exportDataColumn, (String)"null")) {
                cell.setCellValue(exportDataColumn);
                row.setHeight((short)350);
                cell.setCellStyle(dataStyle);
                int width = exportDataColumn.getBytes().length * 350;
                if (width < 4500) {
                    sheet.setColumnWidth(index, 4500);
                } else if (width > 65280) {
                    sheet.setColumnWidth(index, 6000);
                } else {
                    sheet.setColumnWidth(index, width);
                }
            } else {
                cell.setCellValue("");
                row.setHeight((short)350);
                cell.setCellStyle(dataStyle);
                sheet.setColumnWidth(index, 4500);
            }
            ++index;
        }
        row.setHeight((short)500);
    }

    private static List<ExcelHeadModel> makeExcelTmp(ExportModel exportModelVo) {
        String[] heads;
        ArrayList<ExcelHeadModel> excelHeadModels = new ArrayList<ExcelHeadModel>();
        for (String head : heads = exportModelVo.getHeadNames().split(",")) {
            ExcelHeadModel excelHeadModel = new ExcelHeadModel();
            excelHeadModel.setHeadName(head);
            excelHeadModels.add(excelHeadModel);
        }
        return excelHeadModels;
    }
}

