/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class StringHelps {
    public static final char[] DIGITS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] DIGITS_NOCASE = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static void main(String[] args) {
        String json = StringHelps.updateJsonObject(null, "a", "a");
        json = StringHelps.updateJsonObject(json, "b", "b");
        System.out.println(json);
    }

    public static String updateJsonObject(String oldJson, String newKey, Object newValue) {
        JSONObject jsonObject = JSONObject.parseObject((String)oldJson);
        if (null == jsonObject) {
            jsonObject = new JSONObject();
        }
        jsonObject.put(newKey, newValue);
        return jsonObject.toJSONString();
    }

    public static Object getFromJsonObject(String jsonObject, String key) {
        if (StringUtils.isBlank((CharSequence)jsonObject) || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        JSONObject json = JSONObject.parseObject((String)jsonObject);
        return json.get((Object)key);
    }

    public static String bytesToString(byte[] bytes, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return String.valueOf(digits[0]);
        }
        StringBuilder strValue = new StringBuilder();
        int value = 0;
        int limit = 0x7FFFFF;
        int i = 0;
        while (true) {
            if (i < bytes.length && value < limit) {
                value = (value << 8) + (0xFF & bytes[i++]);
                continue;
            }
            while (value >= digitsLength) {
                strValue.append(digits[value % digitsLength]);
                value /= digitsLength;
            }
            if (i >= bytes.length) break;
        }
        if (value != 0 || strValue.length() == 0) {
            strValue.append(digits[value]);
        }
        return strValue.toString();
    }

    public static String longToString(long longValue, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;
        if (longValue == 0L) {
            return String.valueOf(digits[0]);
        }
        if (longValue < 0L) {
            longValue = -longValue;
        }
        StringBuilder strValue = new StringBuilder();
        while (longValue != 0L) {
            int digit = (int)(longValue % (long)digitsLength);
            longValue /= (long)digitsLength;
            strValue.append(digits[digit]);
        }
        return strValue.toString();
    }
}

