/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.autoconfigure.jedis;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.cache.redis.JedisFetcher;
import com.bxm.warcar.cache.redis.JedisSerializationFetcher;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(value={JedisConfiguration.class})
public class JedisFetcherAutoConfiguration {
    @Autowired
    private JedisConfiguration configuration;

    @Bean
    public JedisPool jedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.configuration, this.configuration.getHost(), this.configuration.getPort(), this.configuration.getTimeout(), this.configuration.getPassword(), this.configuration.getDatabase());
    }

    @Bean
    public JedisFetcher jedisFetcher() {
        return new JedisFetcher(this.jedisPool());
    }

    @Bean
    public JedisSerializationFetcher jedisSerializationFetcher() {
        return new JedisSerializationFetcher(this.jedisPool());
    }
}

